/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.group;

import java.util.HashMap;
import java.util.Map;
import journeymap.client.Constants;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import journeymap.common.waypoint.WaypointGroupStore;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class GroupSettingsPopup
extends PopupButtonScreen<Boolean> {
    private final Map<String, String> valueMap = new HashMap<String, String>();

    public GroupSettingsPopup() {
        super((Component)Component.translatable((String)"jm.waypoint.group.edit_settings.title"));
    }

    public void init() {
        GridLayout gridLayout = new GridLayout();
        LinearLayout bottomRowLayout = LinearLayout.horizontal();
        bottomRowLayout.spacing(4);
        this.layout.spacing(6);
        this.layout.addChild((LayoutElement)gridLayout);
        this.layout.addChild((LayoutElement)bottomRowLayout, LayoutSettings::alignHorizontallyCenter);
        gridLayout.columnSpacing(6);
        gridLayout.rowSpacing(4);
        ((StringWidget)gridLayout.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"jm.common.hotkeys_keybinding_category").withStyle(ChatFormatting.UNDERLINE), this.font), 0, 0)).setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.group.edit_settings.journeymap.tooltip")));
        ((CheckBox)gridLayout.addChild((LayoutElement)this.checkbox(Constants.getString("jm.waypoint.group.edit_settings.hide_all"), "hide_all"), 2, 0)).setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.group.edit_settings.hide_all.tooltip")));
        ((CheckBox)gridLayout.addChild((LayoutElement)this.checkbox(Constants.getString("jm.waypoint.group.edit_settings.hide_death"), "hide_empty_death"), 4, 0)).setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.group.edit_settings.hide_death.tooltip")));
        ((CheckBox)gridLayout.addChild((LayoutElement)this.checkbox(Constants.getString("jm.waypoint.group.edit_settings.hide_temp"), "hide_empty_temp"), 6, 0)).setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.group.edit_settings.hide_temp.tooltip")));
        ((StringWidget)gridLayout.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"jm.waypoint.group.edit_settings.custom").withStyle(ChatFormatting.UNDERLINE), this.font), 0, 2)).setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.group.edit_settings.custom.tooltip")));
        ((CheckBox)gridLayout.addChild((LayoutElement)this.checkbox(Constants.getString("jm.waypoint.group.edit_settings.hide_custom"), "hide_empty"), 2, 2)).setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.group.edit_settings.hide_custom.tooltip")));
        bottomRowLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.waypoint.save"), b -> this.exit(false)).width(this.font.width((FormattedText)CommonComponents.GUI_CONTINUE) + 10).build());
        bottomRowLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, b -> this.exit(true)).width(this.font.width((FormattedText)CommonComponents.GUI_CANCEL) + 10).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    private CheckBox checkbox(String title, String key) {
        boolean value = Boolean.parseBoolean(WaypointGroupStore.getDisplaySetting(key, "false"));
        return new CheckBox(title, value, button -> this.valueMap.put(key, ((CheckBox)button).getToggled().toString()));
    }

    private void exit(boolean canceled) {
        if (!canceled) {
            this.valueMap.forEach(WaypointGroupStore::setDisplaySetting);
            this.setResponseAndClose(true);
        } else {
            this.setResponseAndClose(false);
        }
    }
}

