/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.client.impl;

import journeymap.api.v2.client.fullscreen.IBlockInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;

public class BlockInfo
implements IBlockInfo {
    private BlockPos blockPos;
    private Block block;
    private BlockState blockState;
    private Biome biome;
    private LevelChunk chunk;
    private ChunkPos chunkPos;
    private Integer regionX;
    private Integer regionZ;

    private BlockInfo(Builder builder) {
        this.blockPos = builder.blockPos;
        this.block = builder.block;
        this.blockState = builder.blockState;
        this.biome = builder.biome;
        this.chunk = builder.chunk;
        this.chunkPos = builder.chunkPos;
        this.regionX = builder.regionX;
        this.regionZ = builder.regionZ;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public Biome getBiome() {
        return this.biome;
    }

    public LevelChunk getChunk() {
        return this.chunk;
    }

    public ChunkPos getChunkPos() {
        return this.chunkPos;
    }

    public Integer getRegionX() {
        return this.regionX;
    }

    public Integer getRegionZ() {
        return this.regionZ;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private BlockPos blockPos;
        private Block block;
        private BlockState blockState;
        private Biome biome;
        private LevelChunk chunk;
        private ChunkPos chunkPos;
        private Integer regionX;
        private Integer regionZ;

        public BlockInfo build() {
            return new BlockInfo(this);
        }

        public Builder withBlockPos(BlockPos blockPos) {
            this.blockPos = blockPos;
            return this;
        }

        public Builder withBlock(Block block) {
            this.block = block;
            return this;
        }

        public Builder withBlockState(BlockState blockState) {
            this.blockState = blockState;
            return this;
        }

        public Builder withBiome(Biome biome) {
            this.biome = biome;
            return this;
        }

        public Builder withChunk(LevelChunk chunk) {
            this.chunk = chunk;
            return this;
        }

        public Builder withChunkPos(ChunkPos chunkPos) {
            this.chunkPos = chunkPos;
            return this;
        }

        public Builder withRegionX(Integer regionX) {
            this.regionX = regionX;
            return this;
        }

        public Builder withRegionZ(Integer regionZ) {
            this.regionZ = regionZ;
            return this;
        }
    }
}

