/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.stateless.StatelessGeoBlockEntity;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.network.packet.MultiloaderPacket;
import software.bernie.geckolib.util.ClientUtil;

public record StatelessBlockEntityPlayAnimPacket(BlockPos blockPos, RawAnimation animation) implements MultiloaderPacket
{
    public static final CustomPacketPayload.Type<StatelessBlockEntityPlayAnimPacket> TYPE = new CustomPacketPayload.Type(GeckoLibConstants.id("stateless_block_entity_play_anim"));
    public static final StreamCodec<FriendlyByteBuf, StatelessBlockEntityPlayAnimPacket> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, StatelessBlockEntityPlayAnimPacket::blockPos, RawAnimation.STREAM_CODEC, StatelessBlockEntityPlayAnimPacket::animation, StatelessBlockEntityPlayAnimPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void receiveMessage(@Nullable Player sender, Consumer<Runnable> workQueue) {
        workQueue.accept(() -> {
            GeoBlockEntity blockEntity;
            BlockEntity patt0$temp = ClientUtil.getLevel().getBlockEntity(this.blockPos);
            if (patt0$temp instanceof GeoBlockEntity && (blockEntity = (GeoBlockEntity)patt0$temp) instanceof StatelessGeoBlockEntity) {
                StatelessGeoBlockEntity statelessAnimatable = (StatelessGeoBlockEntity)blockEntity;
                statelessAnimatable.handleClientAnimationPlay(blockEntity, 0L, this.animation);
            }
        });
    }
}

