/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.nuclear.reactor.rod;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.antarcticgardens.cna.CNABlockEntityTypes;
import org.antarcticgardens.cna.CNABlocks;
import org.antarcticgardens.cna.content.nuclear.reactor.ReactorBlock;
import org.antarcticgardens.cna.content.nuclear.reactor.rod.ReactorRodBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactorRodBlock
extends ReactorBlock
implements EntityBlock {
    protected static final VoxelShape Y_AXIS_AABB = Block.box((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)16.0, (double)11.5);
    protected static final VoxelShape Z_AXIS_AABB = Block.box((double)4.5, (double)4.5, (double)0.0, (double)11.5, (double)11.5, (double)16.0);
    protected static final VoxelShape X_AXIS_AABB = Block.box((double)0.0, (double)4.5, (double)4.5, (double)16.0, (double)11.5, (double)11.5);
    public static final BooleanProperty ACTIVE = BlockStateProperties.LIT;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;

    public ReactorRodBlock(BlockBehaviour.Properties properties) {
        super(properties.isViewBlocking((blockState, blockGetter, blockPos) -> false).lightLevel(state -> (Boolean)state.getValue((Property)ACTIVE) != false ? 12 : 0));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.Y));
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).setValue(AXIS, (Comparable)context.getClickedFace().getAxis());
    }

    public VoxelShape getShape(BlockState arg, BlockGetter arg2, BlockPos arg3, CollisionContext arg4) {
        return switch ((Direction.Axis)arg.getValue(AXIS)) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> X_AXIS_AABB;
            case Direction.Axis.Z -> Z_AXIS_AABB;
            case Direction.Axis.Y -> Y_AXIS_AABB;
        };
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
        if (((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            level.setBlock(pos, CNABlocks.CORIUM.getDefaultState(), 3);
            if (level instanceof ServerLevel) {
                ServerLevel lvl = (ServerLevel)level;
                lvl.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 2.0f, true, Level.ExplosionInteraction.TNT);
            }
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        return (Boolean)state.getValue((Property)ACTIVE) != false ? new ArrayList() : super.getDrops(state, params);
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if (((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            return InteractionResult.PASS;
        }
        return super.onSneakWrenched(state, context);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE}).add(new Property[]{AXIS});
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return CNABlockEntityTypes.REACTOR_ROD.create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        return (level1, blockPos, blockState, blockEntity) -> {
            if (!(blockEntity instanceof ReactorRodBlockEntity)) {
                return;
            }
            ReactorRodBlockEntity ent = (ReactorRodBlockEntity)blockEntity;
            ent.tick(blockPos, level1, blockState);
        };
    }
}

