/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.heat.stirling;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.antarcticgardens.cna.content.heat.stirling.StirlingEngineBlockEntity;
import org.jetbrains.annotations.Nullable;

public class StirlingEngineBlock
extends RotatedPillarKineticBlock
implements IBE<StirlingEngineBlockEntity> {
    private final BlockEntityEntry<StirlingEngineBlockEntity> entry;

    public StirlingEngineBlock(BlockBehaviour.Properties properties, BlockEntityEntry<StirlingEngineBlockEntity> entry) {
        super(properties);
        this.entry = entry;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction.Axis axis = StirlingEngineBlock.getPreferredAxis((BlockPlaceContext)context);
        if (axis == null || context.getClickedFace().getAxis().isVertical()) {
            axis = context.getHorizontalDirection().getAxis();
        }
        return (BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)axis);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level world = context.getLevel();
        BlockState rotated = (BlockState)state.setValue((Property)AXIS, (Comparable)(state.getValue((Property)AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        if (!rotated.canSurvive((LevelReader)world, context.getClickedPos())) {
            return InteractionResult.PASS;
        }
        KineticBlockEntity.switchToBlockState((Level)world, (BlockPos)context.getClickedPos(), (BlockState)this.updateAfterWrenched(rotated, context));
        BlockEntity be = context.getLevel().getBlockEntity(context.getClickedPos());
        if (be instanceof GeneratingKineticBlockEntity) {
            ((GeneratingKineticBlockEntity)be).reActivateSource = true;
        }
        if (world.getBlockState(context.getClickedPos()) != state) {
            IWrenchable.playRotateSound((Level)world, (BlockPos)context.getClickedPos());
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction.Axis)state.getValue((Property)AXIS)) {
            case Direction.Axis.X -> Block.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
            default -> Block.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0);
        };
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.getAxis() == this.getRotationAxis(state);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.getValue((Property)AXIS);
    }

    public Class<StirlingEngineBlockEntity> getBlockEntityClass() {
        return StirlingEngineBlockEntity.class;
    }

    public BlockEntityType<? extends StirlingEngineBlockEntity> getBlockEntityType() {
        return (BlockEntityType)this.entry.get();
    }
}

