/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.electricity.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.antarcticgardens.cna.content.electricity.connector.ElectricalConnectorBlock;
import org.antarcticgardens.cna.content.electricity.connector.ElectricalConnectorBlockEntity;
import org.antarcticgardens.cna.content.electricity.connector.ElectricalConnectorMode;
import org.antarcticgardens.cna.content.electricity.network.EnergyBlockEntity;
import org.antarcticgardens.cna.content.electricity.network.NetworkPath;
import org.antarcticgardens.cna.content.electricity.network.NetworkPathManager;
import org.antarcticgardens.cna.content.electricity.network.NetworkTicker;
import org.antarcticgardens.esl.energy.EnergyStorage;
import org.antarcticgardens.esl.transaction.Transaction;
import org.antarcticgardens.esl.transaction.TransactionContext;
import org.antarcticgardens.esl.transaction.TransactionStack;

public class ElectricalNetwork {
    private final List<ElectricalConnectorBlockEntity> nodes = new ArrayList<ElectricalConnectorBlockEntity>();
    private final Map<ElectricalConnectorBlockEntity, EnergyBlockEntity> consumers = new HashMap<ElectricalConnectorBlockEntity, EnergyBlockEntity>();
    private final Map<ElectricalConnectorBlockEntity, EnergyBlockEntity> pulledSources = new HashMap<ElectricalConnectorBlockEntity, EnergyBlockEntity>();
    private final NetworkPathManager pathManager = new NetworkPathManager();

    public ElectricalNetwork(ElectricalConnectorBlockEntity base) {
        this.nodes.add(base);
    }

    public void addNode(ElectricalConnectorBlockEntity node) {
        this.addNode(node, new ArrayList<ElectricalConnectorBlockEntity>());
        this.updateConsumersAndSources();
    }

    private void addNode(ElectricalConnectorBlockEntity node, List<ElectricalConnectorBlockEntity> processedNodes) {
        if (!this.nodes.contains((Object)node)) {
            this.nodes.add(node);
        }
        processedNodes.add(node);
        if (node.getNetwork() != this) {
            if (node.getNetwork() != null) {
                node.getNetwork().destroy();
            }
            node.setNetwork(this);
            for (ElectricalConnectorBlockEntity connector : node.getConnectedConnectors().keySet()) {
                if (processedNodes.contains((Object)connector)) continue;
                this.addNode(connector, processedNodes);
            }
        }
        for (ElectricalConnectorBlockEntity connectedNode : node.getConnectedConnectors().keySet()) {
            this.pathManager.addConnection(node, connectedNode);
        }
    }

    public void updateConsumersAndSources() {
        this.consumers.clear();
        this.pulledSources.clear();
        for (ElectricalConnectorBlockEntity node : this.nodes) {
            EnergyStorage storage;
            if (node.getLevel() == null) continue;
            Direction dir = (Direction)node.getBlockState().getValue((Property)BlockStateProperties.FACING);
            BlockEntity entity = node.getLevel().getBlockEntity(node.getSupportingBlockPos());
            if (entity == null || entity instanceof ElectricalConnectorBlockEntity || (storage = EnergyStorage.findForBlock((Level)node.getLevel(), (BlockPos)node.getSupportingBlockPos(), (Direction)dir)) == null) continue;
            if (storage.supportsInsertion()) {
                this.consumers.put(node, new EnergyBlockEntity(entity, storage));
            }
            if (!storage.supportsExtraction() || !((ElectricalConnectorMode)((Object)node.getBlockState().getValue(ElectricalConnectorBlock.MODE))).pull) continue;
            this.pulledSources.put(node, new EnergyBlockEntity(entity, storage));
        }
        if (!this.getWorld().isClientSide()) {
            NetworkTicker.addNetwork(this);
        }
    }

    public long insert(ElectricalConnectorBlockEntity from, long amount, TransactionContext txn) {
        if (this.consumers.isEmpty()) {
            return 0L;
        }
        AtomicLong inserted = new AtomicLong();
        long perConsumer = (long)Math.ceil((double)amount / (double)this.consumers.size());
        boolean insertedAny = true;
        while (inserted.get() < amount && insertedAny) {
            insertedAny = false;
            for (Map.Entry<ElectricalConnectorBlockEntity, EnergyBlockEntity> e : this.consumers.entrySet()) {
                long ins;
                if (((Object)((Object)e.getKey())).equals((Object)from) || (ins = this.insertInto(from, e, Math.min(perConsumer, amount - inserted.get()), txn)) <= 0L) continue;
                insertedAny = true;
                inserted.addAndGet(ins);
            }
        }
        return inserted.get();
    }

    private long insertInto(ElectricalConnectorBlockEntity from, Map.Entry<ElectricalConnectorBlockEntity, EnergyBlockEntity> to, long amount, TransactionContext txn) {
        long inserted;
        NetworkPath path;
        long insertedThroughThisPath;
        for (inserted = 0L; (path = this.pathManager.findConductiblePath(from, to.getKey())) != null && inserted < amount; inserted += insertedThroughThisPath) {
            long pathConductivity = this.pathManager.getConductivityContext().calculatePathConductivity(path);
            insertedThroughThisPath = to.getValue().storage().insert(Math.min(pathConductivity, amount - inserted), txn);
            if (insertedThroughThisPath == 0L) break;
            if (insertedThroughThisPath <= 0L) continue;
            BlockEntity be = to.getValue().entity();
            be.setChanged();
            Level level = be.getLevel();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getChunkSource().blockChanged(be.getBlockPos());
            if (pathConductivity == 0L) continue;
            this.pathManager.getConductivityContext().decreasePathConductivity(path, insertedThroughThisPath);
        }
        return inserted;
    }

    public void destroy() {
        NetworkTicker.removeNetwork(this);
        for (ElectricalConnectorBlockEntity node : this.nodes) {
            node.setNetwork(new ElectricalNetwork(node));
        }
    }

    protected void tick() {
        for (Map.Entry<ElectricalConnectorBlockEntity, EnergyBlockEntity> e : this.pulledSources.entrySet()) {
            Transaction txn = TransactionStack.get().openOuter();
            try {
                Transaction test = txn.openNested();
                try {
                    long maxExtracted = e.getValue().storage().extract(Long.MAX_VALUE, (TransactionContext)test);
                    test.abort();
                    long inserted = this.insert(e.getKey(), maxExtracted, (TransactionContext)txn);
                    e.getValue().storage().extract(inserted, (TransactionContext)txn);
                    txn.commit();
                }
                finally {
                    if (test == null) continue;
                    test.close();
                }
            }
            finally {
                if (txn == null) continue;
                txn.close();
            }
        }
        this.pathManager.tick();
    }

    public Level getWorld() {
        return this.nodes.get(0).getLevel();
    }

    public List<ElectricalConnectorBlockEntity> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public NetworkPathManager getPathManager() {
        return this.pathManager;
    }
}

