/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.electricity.connector;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.antarcticgardens.cna.CNABlockEntityTypes;
import org.antarcticgardens.cna.CNABlocks;
import org.antarcticgardens.cna.content.electricity.connector.ElectricalConnectorBlockEntity;
import org.antarcticgardens.cna.content.electricity.connector.ElectricalConnectorMode;
import org.jetbrains.annotations.Nullable;

public class ElectricalConnectorBlock
extends DirectionalBlock
implements IBE<ElectricalConnectorBlockEntity>,
IWrenchable {
    public static final EnumProperty<ElectricalConnectorMode> MODE = EnumProperty.create((String)"mode", ElectricalConnectorMode.class);
    public static final MapCodec<ElectricalConnectorBlock> CODEC = ElectricalConnectorBlock.simpleCodec(ElectricalConnectorBlock::new);

    public ElectricalConnectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, MODE});
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (newState.is((Block)CNABlocks.ELECTRICAL_CONNECTOR.get())) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ElectricalConnectorBlockEntity) {
            ElectricalConnectorBlockEntity connector = (ElectricalConnectorBlockEntity)blockEntity;
            connector.remove(level);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirections()[0].getOpposite())).setValue(MODE, (Comparable)((Object)ElectricalConnectorMode.INERT));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        double a = 4.0;
        double b = 12.0;
        double h = 10.0;
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> Block.box((double)a, (double)a, (double)(16.0 - h), (double)b, (double)b, (double)16.0);
            case Direction.SOUTH -> Block.box((double)a, (double)a, (double)0.0, (double)b, (double)b, (double)h);
            case Direction.WEST -> Block.box((double)(16.0 - h), (double)a, (double)a, (double)16.0, (double)b, (double)b);
            case Direction.EAST -> Block.box((double)0.0, (double)a, (double)a, (double)h, (double)b, (double)b);
            case Direction.UP -> Block.box((double)a, (double)0.0, (double)a, (double)b, (double)h, (double)b);
            case Direction.DOWN -> Block.box((double)a, (double)(16.0 - h), (double)a, (double)b, (double)16.0, (double)b);
        };
    }

    public <S extends BlockEntity> BlockEntityTicker<S> getTicker(Level p_153212_, BlockState p_153213_, BlockEntityType<S> p_153214_) {
        return (level, blockPos, blockState, blockEntity) -> {
            if (blockEntity instanceof ElectricalConnectorBlockEntity) {
                ElectricalConnectorBlockEntity connector = (ElectricalConnectorBlockEntity)blockEntity;
                if (!level.isClientSide) {
                    connector.serverTick();
                }
            }
        };
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ElectricalConnectorBlockEntity) {
            ElectricalConnectorBlockEntity connector = (ElectricalConnectorBlockEntity)blockEntity;
            connector.neighborChanged();
        }
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level world = context.getLevel();
        if (!world.isClientSide()) {
            ElectricalConnectorMode nextMode = ElectricalConnectorMode.values()[(((ElectricalConnectorMode)((Object)state.getValue(MODE))).ordinal() + 1) % ElectricalConnectorMode.values().length];
            world.setBlock(context.getClickedPos(), (BlockState)state.setValue(MODE, (Comparable)((Object)nextMode)), 3);
            BlockEntity blockEntity = world.getBlockEntity(context.getClickedPos());
            if (blockEntity instanceof ElectricalConnectorBlockEntity) {
                ElectricalConnectorBlockEntity connector = (ElectricalConnectorBlockEntity)blockEntity;
                connector.getNetwork().updateConsumersAndSources();
            }
            IWrenchable.playRotateSound((Level)world, (BlockPos)context.getClickedPos());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public Class<ElectricalConnectorBlockEntity> getBlockEntityClass() {
        return ElectricalConnectorBlockEntity.class;
    }

    public BlockEntityType<? extends ElectricalConnectorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CNABlockEntityTypes.ELECTRICAL_CONNECTOR.get();
    }
}

