/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.level;

import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.effect.ChemicalXMobEffect;
import fuzs.mutantmonsters.world.entity.SkullSpirit;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;

public class MutatedExplosionHelper {
    public static void onExplosionDetonate(Level level, Explosion explosion, List<BlockPos> affectedBlocks, List<Entity> affectedEntities) {
        if (explosion.damageCalculator instanceof MutatedExplosionDamageCalculator) {
            affectedEntities.removeIf(entity -> !MutatedExplosionHelper.isAffectedByExplosion(explosion, entity));
        }
    }

    private static boolean isAffectedByExplosion(Explosion explosion, Entity entity) {
        if (entity.ignoreExplosion(explosion)) {
            return false;
        }
        if (entity instanceof MutantCreeper) {
            return false;
        }
        Entity entity2 = explosion.getDirectSourceEntity();
        if (entity2 instanceof SkullSpirit) {
            LivingEntity livingEntity;
            SkullSpirit skullSpirit = (SkullSpirit)entity2;
            if (entity == skullSpirit.getTarget()) {
                return !skullSpirit.isAttached();
            }
            return !(entity instanceof LivingEntity) || ChemicalXMobEffect.IS_APPLICABLE.test(livingEntity = (LivingEntity)entity);
        }
        return true;
    }

    public static Explosion explode(Entity source, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction) {
        return source.level().explode(source, Explosion.getDefaultDamageSource((Level)source.level(), (Entity)source), (ExplosionDamageCalculator)new MutatedExplosionDamageCalculator(), source.getX(), source.getY(), source.getZ(), radius, fire, explosionInteraction, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (Holder)SoundEvents.GENERIC_EXPLODE);
    }

    public static class MutatedExplosionDamageCalculator
    extends ExplosionDamageCalculator {
        public boolean shouldDamageEntity(Explosion explosion, Entity entity) {
            Entity entity2;
            Player player;
            if (entity instanceof Player && (player = (Player)entity).isBlocking() && (entity2 = explosion.getDirectSourceEntity()) instanceof MutantCreeper) {
                MutantCreeper mutantCreeper = (MutantCreeper)entity2;
                float entityDamageAmount = this.getEntityDamageAmount(explosion, entity);
                if (!entity.hurt(explosion.damageSource, entityDamageAmount)) {
                    if (mutantCreeper.isJumpAttacking()) {
                        EntityUtil.disableShield((LivingEntity)player, mutantCreeper.isCharged() ? 200 : 100);
                    } else {
                        ItemHelper.hurtAndBreak((ItemStack)player.getUseItem(), (int)((int)entityDamageAmount * 2), (LivingEntity)player, (InteractionHand)player.getUsedItemHand());
                    }
                    entity.hurt(explosion.damageSource, entityDamageAmount * 0.5f);
                }
                return false;
            }
            return super.shouldDamageEntity(explosion, entity);
        }
    }
}

