/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.item;

import fuzs.mutantmonsters.world.level.SeismicWave;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class HulkHammerItem
extends Item {
    public HulkHammerItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 8.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)-2.9f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return true;
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (context.getClickedFace() != Direction.UP) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide) {
            ArrayList<SeismicWave> seismicWaves = new ArrayList<SeismicWave>();
            Vec3 vec = Vec3.directionFromRotation((float)0.0f, (float)player.getYRot());
            int x = Mth.floor((double)(player.getX() + vec.x * 1.5));
            int y = Mth.floor((double)player.getBoundingBox().minY);
            int z = Mth.floor((double)(player.getZ() + vec.z * 1.5));
            int x1 = Mth.floor((double)(player.getX() + vec.x * 8.0));
            int z1 = Mth.floor((double)(player.getZ() + vec.z * 8.0));
            SeismicWave.createWaves(level, seismicWaves, x, z, x1, z1, y);
            SeismicWave.addAll(player, seismicWaves);
        }
        level.playSound(player, context.getClickedPos(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 0.8f, 0.8f + player.getRandom().nextFloat() * 0.4f);
        player.getCooldowns().addCooldown((Item)this, 25);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        ItemHelper.hurtAndBreak((ItemStack)context.getItemInHand(), (int)1, (LivingEntity)player, (InteractionHand)context.getHand());
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

