/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.item;

import fuzs.mutantmonsters.world.level.MutatedExplosionHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class CreeperShardItem
extends Item {
    public CreeperShardItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public boolean canAttackBlock(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public boolean isFoil(ItemStack stack) {
        return super.isFoil(stack) || stack.getDamageValue() == 0;
    }

    public boolean hurtEnemy(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        Player player = (Player)attacker;
        int damage = itemStack.getDamageValue();
        if (damage > 0) {
            itemStack.setDamageValue(damage - 1);
            if (!player.isCreative() && player.getRandom().nextInt(4) == 0) {
                player.addEffect(new MobEffectInstance(MobEffects.POISON, 80 + player.getRandom().nextInt(40)));
            }
        }
        target.knockback((double)0.9f, player.getX() - target.getX(), player.getZ() - target.getZ());
        player.level().playSound(null, target.blockPosition(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.NEUTRAL, 0.3f, 0.8f + player.getRandom().nextFloat() * 0.4f);
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        int maxDamage = itemInHand.getMaxDamage();
        int damageValue = itemInHand.getDamageValue();
        if (damageValue < maxDamage) {
            if (!level.isClientSide) {
                float radius = 5.0f * (float)(maxDamage - damageValue) / 16.0f;
                if (damageValue == 0) {
                    radius += 2.0f;
                }
                level.explode((Entity)player, Explosion.getDefaultDamageSource((Level)level, (Entity)player), (ExplosionDamageCalculator)new MutatedExplosionHelper.MutatedExplosionDamageCalculator(), player.getX(), player.getY() + 1.0, player.getZ(), radius, false, player.mayBuild() ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE);
            }
            if (!player.getAbilities().instabuild) {
                itemInHand.setDamageValue(damageValue + 1);
            }
            player.getCooldowns().addCooldown((Item)this, (maxDamage - damageValue) * 2);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.success((Object)itemInHand);
        }
        return super.use(level, player, interactionHand);
    }
}

