/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.item;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;

public class ArmorBlockItem
extends StandingAndWallBlockItem
implements Equipable {
    private final Holder<ArmorMaterial> material;
    private final Supplier<ItemAttributeModifiers> defaultModifiers;

    public ArmorBlockItem(Holder<ArmorMaterial> material, Block floorBlock, Block wallBlock, Item.Properties properties) {
        super(floorBlock, wallBlock, properties, Direction.DOWN);
        this.material = material;
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)ArmorItem.DISPENSE_ITEM_BEHAVIOR);
        this.defaultModifiers = Suppliers.memoize(() -> ArmorBlockItem.getDefaultArmorItemModifiers(material, ArmorItem.Type.HELMET));
    }

    static ItemAttributeModifiers getDefaultArmorItemModifiers(Holder<ArmorMaterial> material, ArmorItem.Type type) {
        int defense = ((ArmorMaterial)material.value()).getDefense(type);
        float toughness = ((ArmorMaterial)material.value()).toughness();
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        EquipmentSlotGroup equipmentSlotGroup = EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot());
        ResourceLocation resourceLocation = ResourceLocation.withDefaultNamespace((String)("armor." + type.getName()));
        builder.add(Attributes.ARMOR, new AttributeModifier(resourceLocation, (double)defense, AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(resourceLocation, (double)toughness, AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        float knockbackResistance = ((ArmorMaterial)material.value()).knockbackResistance();
        if (knockbackResistance > 0.0f) {
            builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(resourceLocation, (double)knockbackResistance, AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        }
        return builder.build();
    }

    public int getEnchantmentValue() {
        return ((ArmorMaterial)this.material.value()).enchantmentValue();
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return ((Ingredient)((ArmorMaterial)this.material.value()).repairIngredient().get()).test(repair);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.defaultModifiers.get();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        EquipmentSlot equipmentSlot = player.getEquipmentSlotForItem(itemStack);
        ItemStack itemStack2 = player.getItemBySlot(equipmentSlot);
        if (itemStack2.isEmpty()) {
            player.setItemSlot(equipmentSlot, itemStack.copy());
            if (!level.isClientSide()) {
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
            itemStack.setCount(0);
            return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.HEAD;
    }
}

