/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.AnimatedEntity;
import fuzs.mutantmonsters.world.entity.EntityAnimation;
import fuzs.mutantmonsters.world.entity.MutantSkeletonBodyPart;
import fuzs.mutantmonsters.world.entity.ai.goal.AnimationGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.entity.mutant.AbstractMutantMonster;
import fuzs.mutantmonsters.world.entity.projectile.MutantArrow;
import fuzs.puzzleslib.api.entity.v1.DamageSourcesHelper;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MutantSkeleton
extends AbstractMutantMonster
implements AnimatedEntity {
    public static final EntityAnimation MELEE_ANIMATION = new EntityAnimation(14);
    public static final EntityAnimation CONSTRICT_RIBS_ANIMATION = new EntityAnimation(20);
    public static final EntityAnimation SHOOT_ANIMATION = new EntityAnimation(32);
    public static final EntityAnimation MULTI_SHOT_ANIMATION = new EntityAnimation(30);
    private static final EntityAnimation[] ANIMATIONS = new EntityAnimation[]{MELEE_ANIMATION, CONSTRICT_RIBS_ANIMATION, SHOOT_ANIMATION, MULTI_SHOT_ANIMATION};
    private EntityAnimation animation = EntityAnimation.NONE;
    private int animationTick;

    public MutantSkeleton(EntityType<? extends MutantSkeleton> type, Level worldIn) {
        super(type, worldIn);
        this.xpReward = 30;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return MutantSkeleton.createMonsterAttributes().add(Attributes.MAX_HEALTH, 150.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.FOLLOW_RANGE, 48.0).add(Attributes.MOVEMENT_SPEED, 0.27).add(Attributes.KNOCKBACK_RESISTANCE, 0.75).add(Attributes.STEP_HEIGHT, 1.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new MeleeGoal(this));
        this.goalSelector.addGoal(0, (Goal)new ShootGoal(this));
        this.goalSelector.addGoal(0, (Goal)new MultiShotGoal(this));
        this.goalSelector.addGoal(0, (Goal)new ConstrictRibsGoal(this));
        this.goalSelector.addGoal(1, (Goal)new MutantMeleeAttackGoal((PathfinderMob)this, 1.1).setMaxAttackTick(5));
        this.goalSelector.addGoal(2, (Goal)new AvoidDamageGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByNearestTargetGoal((PathfinderMob)this, WitherBoss.class));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Wolf.class, true));
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    protected void updateNoActionTime() {
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.isAnimationPlaying()) {
            ++this.animationTick;
        }
        if (this.level().isNight() && this.tickCount % 100 == 0 && this.isAlive() && this.getHealth() < this.getMaxHealth()) {
            this.heal(2.0f);
        }
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (!this.isAnimationPlaying()) {
            this.animation = this.random.nextInt(4) != 0 ? MELEE_ANIMATION : CONSTRICT_RIBS_ANIMATION;
        }
        return true;
    }

    public boolean hurt(DamageSource source, float amount) {
        return !(source.getEntity() instanceof MutantSkeleton) && super.hurt(source, amount);
    }

    protected boolean canRide(Entity entityIn) {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    protected void blockedByShield(LivingEntity livingEntity) {
        livingEntity.hurtMarked = true;
    }

    @Override
    public EntityAnimation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(EntityAnimation animation) {
        this.animation = animation;
    }

    @Override
    public EntityAnimation[] getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public void die(DamageSource cause) {
        super.die(cause);
        if (!this.level().isClientSide) {
            for (LivingEntity livingEntity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(3.0, 2.0, 3.0))) {
                livingEntity.hurt(DamageSourcesHelper.source((LevelReader)this.level(), ModRegistry.MUTANT_SKELETON_SHATTER_DAMAGE_TYPE, (Entity)this), 7.0f);
            }
            for (int i = 0; i < 18; ++i) {
                int j = i;
                if (i >= 3) {
                    j = i + 1;
                }
                if (j >= 4) {
                    ++j;
                }
                if (j >= 5) {
                    ++j;
                }
                if (j >= 6) {
                    ++j;
                }
                if (j >= 9) {
                    ++j;
                }
                if (j >= 10) {
                    ++j;
                }
                if (j >= 11) {
                    ++j;
                }
                if (j >= 12) {
                    ++j;
                }
                if (j >= 15) {
                    ++j;
                }
                if (j >= 16) {
                    ++j;
                }
                if (j >= 17) {
                    ++j;
                }
                if (j >= 18) {
                    ++j;
                }
                if (j >= 20) {
                    ++j;
                }
                MutantSkeletonBodyPart part = new MutantSkeletonBodyPart(this.level(), (Mob)this, j);
                part.setDeltaMovement(part.getDeltaMovement().add((double)(this.random.nextFloat() * 0.8f * 2.0f - 0.8f), (double)(this.random.nextFloat() * 0.25f + 0.1f), (double)(this.random.nextFloat() * 0.8f * 2.0f - 0.8f)));
                this.level().addFreshEntity((Entity)part);
            }
        }
        this.deathTime = 19;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSoundEvents.ENTITY_MUTANT_SKELETON_AMBIENT_SOUND_EVENT.value();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.ENTITY_MUTANT_SKELETON_HURT_SOUND_EVENT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.ENTITY_MUTANT_SKELETON_DEATH_SOUND_EVENT.value();
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)ModSoundEvents.ENTITY_MUTANT_SKELETON_STEP_SOUND_EVENT.value(), 0.15f, 1.0f);
    }

    static class MeleeGoal
    extends AnimationGoal<MutantSkeleton> {
        public MeleeGoal(MutantSkeleton mob) {
            super(mob);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return MELEE_ANIMATION;
        }

        public void tick() {
            ((MutantSkeleton)this.mob).getNavigation().stop();
            LivingEntity target = ((MutantSkeleton)this.mob).getTarget();
            if (target != null && target.isAlive()) {
                ((MutantSkeleton)this.mob).lookControl.setLookAt((Entity)target, 30.0f, 30.0f);
            }
            if (((MutantSkeleton)this.mob).animationTick == 3) {
                float attackDamage = (float)((MutantSkeleton)this.mob).getAttributeValue(Attributes.ATTACK_DAMAGE);
                for (LivingEntity livingEntity : ((MutantSkeleton)this.mob).level().getEntitiesOfClass(LivingEntity.class, ((MutantSkeleton)this.mob).getBoundingBox().inflate(4.0))) {
                    if (livingEntity instanceof MutantSkeleton) continue;
                    double dist = ((MutantSkeleton)this.mob).distanceTo((Entity)livingEntity);
                    double x = ((MutantSkeleton)this.mob).getX() - livingEntity.getX();
                    double z = ((MutantSkeleton)this.mob).getZ() - livingEntity.getZ();
                    if (!(dist <= 3.0) || !(EntityUtil.getHeadAngle((LivingEntity)this.mob, x, z) < 60.0f)) continue;
                    float power = 1.8f + (float)((MutantSkeleton)this.mob).random.nextInt(5) * 0.15f;
                    livingEntity.hurt(((MutantSkeleton)this.mob).level().damageSources().mobAttack((LivingEntity)this.mob), attackDamage > 0.0f ? attackDamage + (float)((MutantSkeleton)this.mob).random.nextInt(2) : 0.0f);
                    livingEntity.setDeltaMovement(-x / dist * (double)power, Math.max((double)0.28f, livingEntity.getDeltaMovement().y), -z / dist * (double)power);
                    EntityUtil.sendPlayerVelocityPacket((Entity)livingEntity);
                }
                ((MutantSkeleton)this.mob).playSound(SoundEvents.PLAYER_ATTACK_KNOCKBACK, 1.0f, 1.0f / (((MutantSkeleton)this.mob).random.nextFloat() * 0.4f + 1.2f));
            }
        }
    }

    static class ShootGoal
    extends AnimationGoal<MutantSkeleton> {
        public ShootGoal(MutantSkeleton mob) {
            super(mob);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return SHOOT_ANIMATION;
        }

        @Override
        public boolean canUse() {
            LivingEntity target = ((MutantSkeleton)this.mob).getTarget();
            return target != null && !((MutantSkeleton)this.mob).isAnimationPlaying() && ((MutantSkeleton)this.mob).random.nextInt(12) == 0 && ((MutantSkeleton)this.mob).distanceToSqr((Entity)target) > 4.0 && ((MutantSkeleton)this.mob).hasLineOfSight((Entity)target);
        }

        public void tick() {
            LivingEntity target = ((MutantSkeleton)this.mob).getTarget();
            if (target != null) {
                ((MutantSkeleton)this.mob).getNavigation().stop();
                ((MutantSkeleton)this.mob).lookControl.setLookAt((Entity)target, 30.0f, 30.0f);
                if (((MutantSkeleton)this.mob).animationTick == 5) {
                    ((MutantSkeleton)this.mob).playSound((SoundEvent)SoundEvents.CROSSBOW_QUICK_CHARGE_2.value(), 1.0f, 1.0f);
                }
                if (((MutantSkeleton)this.mob).animationTick == 20) {
                    ((MutantSkeleton)this.mob).playSound((SoundEvent)SoundEvents.CROSSBOW_LOADING_END.value(), 1.0f, 1.0f / (((MutantSkeleton)this.mob).random.nextFloat() * 0.5f + 1.0f) + 0.2f);
                }
                if (((MutantSkeleton)this.mob).animationTick == 26 && target.isAlive()) {
                    float randomization = (float)((MutantSkeleton)this.mob).hurtTime / 2.0f;
                    if (((MutantSkeleton)this.mob).hurtTime > 0 && ((MutantSkeleton)this.mob).lastHurt > 0.0f && ((MutantSkeleton)this.mob).getLastDamageSource() != null && ((MutantSkeleton)this.mob).getLastDamageSource().getEntity() != null) {
                        randomization = (float)((MutantSkeleton)this.mob).hurtTime / 2.0f;
                    } else if (!((MutantSkeleton)this.mob).hasLineOfSight((Entity)target)) {
                        randomization = 0.5f + ((MutantSkeleton)this.mob).random.nextFloat();
                    }
                    MutantArrow mutantArrow = new MutantArrow(((MutantSkeleton)this.mob).level(), (LivingEntity)this.mob);
                    mutantArrow.shoot(target, 2.4f, randomization);
                    if (((MutantSkeleton)this.mob).random.nextInt(4) == 0) {
                        mutantArrow.addEffect(new MobEffectInstance(MobEffects.POISON, 80 + ((MutantSkeleton)this.mob).random.nextInt(60), 0));
                    }
                    if (((MutantSkeleton)this.mob).random.nextInt(4) == 0) {
                        mutantArrow.addEffect(new MobEffectInstance(MobEffects.HUNGER, 120 + ((MutantSkeleton)this.mob).random.nextInt(60), 1));
                    }
                    if (((MutantSkeleton)this.mob).random.nextInt(4) == 0) {
                        mutantArrow.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 120 + ((MutantSkeleton)this.mob).random.nextInt(60), 1));
                    }
                    ((MutantSkeleton)this.mob).level().addFreshEntity((Entity)mutantArrow);
                    ((MutantSkeleton)this.mob).playSound(SoundEvents.CROSSBOW_SHOOT, 1.0f, 1.0f / (((MutantSkeleton)this.mob).random.nextFloat() * 0.4f + 1.2f) + 0.25f);
                }
            }
        }
    }

    static class MultiShotGoal
    extends AnimationGoal<MutantSkeleton> {
        private final List<MutantArrow> shots = new ArrayList<MutantArrow>();

        public MultiShotGoal(MutantSkeleton mob) {
            super(mob);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return MULTI_SHOT_ANIMATION;
        }

        @Override
        public boolean canUse() {
            LivingEntity target = ((MutantSkeleton)this.mob).getTarget();
            return target != null && ((MutantSkeleton)this.mob).tickCount % 3 == 0 && !((MutantSkeleton)this.mob).isAnimationPlaying() && (((MutantSkeleton)this.mob).onGround() && ((MutantSkeleton)this.mob).random.nextInt(26) == 0 && ((MutantSkeleton)this.mob).hasLineOfSight((Entity)target) || ((MutantSkeleton)this.mob).getVehicle() == target);
        }

        public void tick() {
            LivingEntity target = ((MutantSkeleton)this.mob).getTarget();
            if (target != null) {
                ((MutantSkeleton)this.mob).getNavigation().stop();
                ((MutantSkeleton)this.mob).lookControl.setLookAt((Entity)target, 30.0f, 30.0f);
                if (((MutantSkeleton)this.mob).animationTick == 10) {
                    ((MutantSkeleton)this.mob).stopRiding();
                    double x = target.getX() - ((MutantSkeleton)this.mob).getX();
                    double z = target.getZ() - ((MutantSkeleton)this.mob).getZ();
                    float scale = 0.06f + ((MutantSkeleton)this.mob).random.nextFloat() * 0.03f;
                    if (((MutantSkeleton)this.mob).distanceToSqr((Entity)target) < 16.0) {
                        x *= -1.0;
                        z *= -1.0;
                        scale = (float)((double)scale * 5.0);
                    }
                    ((MutantSkeleton)this.mob).stuckSpeedMultiplier = Vec3.ZERO;
                    ((MutantSkeleton)this.mob).setDeltaMovement(x * (double)scale, 1.1 * (double)((MutantSkeleton)this.mob).getBlockJumpFactor(), z * (double)scale);
                }
                if (((MutantSkeleton)this.mob).animationTick == 15) {
                    ((MutantSkeleton)this.mob).playSound((SoundEvent)SoundEvents.CROSSBOW_QUICK_CHARGE_3.value(), 1.0f, 1.0f);
                }
                if (((MutantSkeleton)this.mob).animationTick == 20) {
                    ((MutantSkeleton)this.mob).playSound((SoundEvent)SoundEvents.CROSSBOW_LOADING_END.value(), 1.0f, 1.0f / (((MutantSkeleton)this.mob).random.nextFloat() * 0.5f + 1.0f) + 0.2f);
                }
                if (((MutantSkeleton)this.mob).animationTick >= 24 && ((MutantSkeleton)this.mob).animationTick < 28) {
                    if (!this.shots.isEmpty()) {
                        for (MutantArrow arrowEntity : this.shots) {
                            ((MutantSkeleton)this.mob).level().addFreshEntity((Entity)arrowEntity);
                        }
                        this.shots.clear();
                    }
                    for (int i = 0; i < 6; ++i) {
                        MutantArrow mutantArrow = new MutantArrow(((MutantSkeleton)this.mob).level(), (LivingEntity)this.mob);
                        mutantArrow.shoot(target, 2.0f - ((MutantSkeleton)this.mob).random.nextFloat() * 0.1f, 3.0f);
                        this.shots.add(mutantArrow);
                    }
                    ((MutantSkeleton)this.mob).playSound(SoundEvents.CROSSBOW_SHOOT, 1.0f, 1.0f / (((MutantSkeleton)this.mob).random.nextFloat() * 0.4f + 1.2f) + 0.25f);
                }
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.shots.clear();
        }
    }

    static class ConstrictRibsGoal
    extends AnimationGoal<MutantSkeleton> {
        public ConstrictRibsGoal(MutantSkeleton mob) {
            super(mob);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return CONSTRICT_RIBS_ANIMATION;
        }

        @Override
        public boolean canUse() {
            return ((MutantSkeleton)this.mob).getTarget() != null && super.canUse();
        }

        public void tick() {
            LivingEntity target = ((MutantSkeleton)this.mob).getTarget();
            if (target != null) {
                ((MutantSkeleton)this.mob).getNavigation().stop();
                if (((MutantSkeleton)this.mob).animationTick < 6) {
                    ((MutantSkeleton)this.mob).lookControl.setLookAt((Entity)target, 30.0f, 30.0f);
                }
                if (((MutantSkeleton)this.mob).animationTick == 5) {
                    target.stopRiding();
                }
                if (((MutantSkeleton)this.mob).animationTick == 6) {
                    float attackDamage = (float)((MutantSkeleton)this.mob).getAttributeValue(Attributes.ATTACK_DAMAGE);
                    if (!target.hurt(((MutantSkeleton)this.mob).level().damageSources().mobAttack((LivingEntity)this.mob), attackDamage > 0.0f ? attackDamage + 6.0f : 0.0f)) {
                        EntityUtil.disableShield(target, 100);
                    }
                    double motionX = (double)(1.0f + ((MutantSkeleton)this.mob).random.nextFloat() * 0.4f) * (double)(((MutantSkeleton)this.mob).random.nextBoolean() ? 1 : -1);
                    double motionY = 0.4f + ((MutantSkeleton)this.mob).random.nextFloat() * 0.8f;
                    double motionZ = (double)(1.0f + ((MutantSkeleton)this.mob).random.nextFloat() * 0.4f) * (double)(((MutantSkeleton)this.mob).random.nextBoolean() ? 1 : -1);
                    target.setDeltaMovement(motionX, motionY, motionZ);
                    EntityUtil.sendPlayerVelocityPacket((Entity)target);
                    ((MutantSkeleton)this.mob).playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 0.5f, 0.8f + ((MutantSkeleton)this.mob).random.nextFloat() * 0.4f);
                }
            }
        }
    }
}

