/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.ai.goal;

import fuzs.mutantmonsters.world.entity.CreeperMinion;
import java.util.EnumSet;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;

public class OwnerTargetGoal
extends TargetGoal {
    private final TamableAnimal tameable;
    private int timestamp;

    public OwnerTargetGoal(TamableAnimal tameable) {
        super((Mob)tameable, false);
        this.tameable = tameable;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        if ((this.tameable.isTame() || this.tameable instanceof CreeperMinion) && !this.tameable.isOrderedToSit()) {
            boolean hasTarget;
            int currentTimestamp;
            LivingEntity owner = this.tameable.getOwner();
            if (owner == null) {
                return false;
            }
            if (owner.getLastHurtByMob() != null) {
                this.targetMob = owner.getLastHurtByMob();
                currentTimestamp = owner.getLastHurtByMobTimestamp();
            } else if (owner instanceof Mob) {
                this.targetMob = ((Mob)owner).getTarget();
                currentTimestamp = owner.tickCount;
            } else {
                this.targetMob = owner.getLastHurtMob();
                currentTimestamp = owner.getLastHurtMobTimestamp();
            }
            boolean bl = hasTarget = currentTimestamp != this.timestamp && this.canAttack(this.targetMob, TargetingConditions.DEFAULT) && this.tameable.wantsToAttack(this.targetMob, owner);
            if (hasTarget) {
                this.timestamp = currentTimestamp;
            }
            return hasTarget;
        }
        return false;
    }

    public void start() {
        super.start();
        this.mob.setTarget(this.targetMob);
    }

    protected boolean canAttack(LivingEntity potentialTarget, TargetingConditions targetPredicate) {
        return potentialTarget != null && targetPredicate.test((LivingEntity)this.mob, potentialTarget);
    }
}

