/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.ai.goal;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;

public class HurtByNearestTargetGoal
extends HurtByTargetGoal {
    public HurtByNearestTargetGoal(PathfinderMob creatureIn, Class<?> ... excludeReinforcementTypes) {
        super(creatureIn, (Class[])excludeReinforcementTypes);
    }

    public boolean canUse() {
        if (!super.canUse()) {
            LivingEntity lastTarget = this.mob.getLastHurtMob();
            if (lastTarget != null && this.mob.getLastHurtByMob() == null) {
                this.mob.setLastHurtByMob(lastTarget);
            }
            return false;
        }
        return true;
    }

    public boolean canContinueToUse() {
        if (!super.canContinueToUse()) {
            return false;
        }
        LivingEntity revengeTarget = this.mob.getLastHurtByMob();
        if (super.canUse() && revengeTarget != this.targetMob && this.mob.distanceToSqr((Entity)revengeTarget) < this.mob.distanceToSqr((Entity)this.targetMob)) {
            this.mob.setLastHurtMob((Entity)this.targetMob);
            return false;
        }
        return true;
    }

    protected boolean canAttack(LivingEntity potentialTarget, TargetingConditions targetPredicate) {
        return (!(potentialTarget instanceof TamableAnimal) || !(this.mob instanceof TamableAnimal) || !((TamableAnimal)potentialTarget).isOwnedBy(((TamableAnimal)this.mob).getOwner())) && super.canAttack(potentialTarget, targetPredicate);
    }
}

