/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.network;

import fuzs.mutantmonsters.world.entity.AnimatedEntity;
import fuzs.mutantmonsters.world.entity.EntityAnimation;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class S2CAnimationMessage
implements MessageV2<S2CAnimationMessage> {
    private int entityId;
    private int index;

    public S2CAnimationMessage() {
    }

    public S2CAnimationMessage(int entityId, int index) {
        this.entityId = entityId;
        this.index = index;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeVarInt(this.entityId);
        buf.writeVarInt(this.index);
    }

    public void read(FriendlyByteBuf buf) {
        this.entityId = buf.readVarInt();
        this.index = buf.readVarInt();
    }

    public MessageV2.MessageHandler<S2CAnimationMessage> makeHandler() {
        return new MessageV2.MessageHandler<S2CAnimationMessage>(this){

            public void handle(S2CAnimationMessage message, Player player, Object gameInstance) {
                ClientLevel level = ((Minecraft)gameInstance).level;
                Entity entity = level.getEntity(message.entityId);
                if (entity instanceof AnimatedEntity) {
                    AnimatedEntity animatedEntity = (AnimatedEntity)entity;
                    if (message.index == -1) {
                        animatedEntity.setAnimation(EntityAnimation.NONE);
                    } else {
                        animatedEntity.setAnimation(animatedEntity.getAnimations()[message.index]);
                    }
                    animatedEntity.setAnimationTick(0);
                }
            }
        };
    }
}

