/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.network.client.C2SCreeperMinionNameMessage;
import fuzs.mutantmonsters.network.client.C2SCreeperMinionTrackerMessage;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class CreeperMinionTrackerScreen
extends Screen {
    public static final ResourceLocation TEXTURE_LOCATION = MutantMonsters.id("textures/gui/creeper_minion_tracker.png");
    public static final Component HEALTH_COMPONENT = Component.translatable((String)"gui.mutantmonsters.creeper_minion_tracker.health");
    public static final Component EXPLOSION_COMPONENT = Component.translatable((String)"gui.mutantmonsters.creeper_minion_tracker.explosion");
    public static final Component BLAST_RADIUS_COMPONENT = Component.translatable((String)"gui.mutantmonsters.creeper_minion_tracker.blast_radius");
    public static final Component CONTINUOUS_EXPLOSION_COMPONENT = Component.translatable((String)"gui.mutantmonsters.creeper_minion_tracker.explosion.continuous");
    public static final Component ONE_TIME_EXPLOSION_COMPONENT = Component.translatable((String)"gui.mutantmonsters.creeper_minion_tracker.explosion.one_time");
    public static final Component SHOW_NAME_COMPONENT = Component.translatable((String)"gui.mutantmonsters.creeper_minion_tracker.show_name");
    public static final Component DESTROY_BLOCKS_COMPONENT = Component.translatable((String)"gui.mutantmonsters.creeper_minion_tracker.destroys_blocks");
    public static final Component RIDE_ON_SHOULDER_COMPONENT = Component.translatable((String)"gui.mutantmonsters.creeper_minion_tracker.ride_on_shoulder");
    private static final DecimalFormat DECIMAL_FORMAT = (DecimalFormat)Util.make((Object)new DecimalFormat("#.0"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    private final int imageWidth = 176;
    private final int imageHeight = 166;
    private final CreeperMinion creeperMinion;
    private int leftPos;
    private int topPos;
    private EditBox name;
    private boolean canRideOnShoulder;
    private boolean canDestroyBlocks;
    private boolean alwaysShowName;
    private int titleLabelX;
    private int titleLabelY;

    public CreeperMinionTrackerScreen(CreeperMinion creeperMinion) {
        super(creeperMinion.getType().getDescription());
        this.creeperMinion = creeperMinion;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawString(this.font, this.title, this.leftPos + this.titleLabelX, this.topPos + this.titleLabelY, 0x404040, false);
        this.name.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawString(this.font, HEALTH_COMPONENT, this.leftPos + 13, this.topPos + 31, 0x404040, false);
        guiGraphics.drawString(this.font, EXPLOSION_COMPONENT, this.leftPos + 13, this.topPos + 51, 0x404040, false);
        guiGraphics.drawString(this.font, BLAST_RADIUS_COMPONENT, this.leftPos + 13, this.topPos + 71, 0x404040, false);
        guiGraphics.drawCenteredString(this.font, String.format("%s / %s", DECIMAL_FORMAT.format(this.creeperMinion.getHealth()), DECIMAL_FORMAT.format(this.creeperMinion.getMaxHealth())), this.leftPos + this.imageWidth / 2 + 38, this.topPos + 31, 0xFFFFFF);
        guiGraphics.drawCenteredString(this.font, this.creeperMinion.canExplodeContinuously() ? CONTINUOUS_EXPLOSION_COMPONENT : ONE_TIME_EXPLOSION_COMPONENT, this.leftPos + this.imageWidth / 2 + 38, this.topPos + 51, 0xFFFFFF);
        guiGraphics.drawCenteredString(this.font, DECIMAL_FORMAT.format(this.creeperMinion.getExplosionRadius()), this.leftPos + this.imageWidth / 2 + 38, this.topPos + 71, 0xFFFFFF);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.shouldCloseOnEsc()) {
            this.onClose();
            return true;
        }
        return this.name.keyPressed(keyCode, scanCode, modifiers) || this.name.canConsumeInput() || super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void init() {
        this.canDestroyBlocks = this.creeperMinion.canDestroyBlocks();
        this.alwaysShowName = this.creeperMinion.isCustomNameVisible();
        this.canRideOnShoulder = this.creeperMinion.canRideOnShoulder();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.name = new EditBox(this.font, this.leftPos + 5, this.topPos - 24, this.imageHeight, 20, (Component)Component.empty());
        this.name.setTextColor(-1);
        this.name.setTextColorUneditable(-1);
        this.name.setMaxLength(50);
        this.name.setResponder(this::onNameChanged);
        this.name.setValue(this.creeperMinion.getName().getString());
        this.addWidget((GuiEventListener)this.name);
        int buttonWidth = this.imageWidth / 2 - 10;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CreeperMinionTrackerScreen.onOffComponent(DESTROY_BLOCKS_COMPONENT, this.canDestroyBlocks), button -> {
            this.canDestroyBlocks = !this.canDestroyBlocks;
            MutantMonsters.NETWORK.sendToServer(new C2SCreeperMinionTrackerMessage(this.creeperMinion, 0, this.canDestroyBlocks).toServerboundMessage());
            button.setMessage(CreeperMinionTrackerScreen.onOffComponent(DESTROY_BLOCKS_COMPONENT, this.canDestroyBlocks));
        }).bounds(this.leftPos + 8, this.topPos + this.imageHeight - 75, buttonWidth * 2 + 4, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CreeperMinionTrackerScreen.onOffComponent(SHOW_NAME_COMPONENT, this.alwaysShowName), button -> {
            this.alwaysShowName = !this.alwaysShowName;
            MutantMonsters.NETWORK.sendToServer(new C2SCreeperMinionTrackerMessage(this.creeperMinion, 1, this.alwaysShowName).toServerboundMessage());
            button.setMessage(CreeperMinionTrackerScreen.onOffComponent(SHOW_NAME_COMPONENT, this.alwaysShowName));
        }).bounds(this.leftPos + 8, this.topPos + this.imageHeight - 51, buttonWidth * 2 + 4, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CreeperMinionTrackerScreen.onOffComponent(RIDE_ON_SHOULDER_COMPONENT, this.canRideOnShoulder), button -> {
            this.canRideOnShoulder = !this.canRideOnShoulder;
            MutantMonsters.NETWORK.sendToServer(new C2SCreeperMinionTrackerMessage(this.creeperMinion, 2, this.canRideOnShoulder).toServerboundMessage());
            button.setMessage(CreeperMinionTrackerScreen.onOffComponent(RIDE_ON_SHOULDER_COMPONENT, this.canRideOnShoulder));
        }).bounds(this.leftPos + 8, this.topPos + this.imageHeight - 27, buttonWidth * 2 + 4, 20).build());
        if (!this.creeperMinion.isOwnedBy((LivingEntity)this.minecraft.player)) {
            this.renderables.stream().filter(AbstractWidget.class::isInstance).map(AbstractWidget.class::cast).forEach(widget -> {
                widget.active = false;
            });
        }
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        this.titleLabelY = 6;
    }

    public void tick() {
        if (!this.creeperMinion.isAlive()) {
            this.minecraft.player.closeContainer();
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(TEXTURE_LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        guiGraphics.blit(TEXTURE_LOCATION, this.leftPos + 15, this.topPos + 16, 0, 166, 146, 5);
        float healthProgress = Mth.clamp((float)(this.creeperMinion.getHealth() / this.creeperMinion.getMaxHealth()), (float)0.0f, (float)1.0f);
        guiGraphics.blit(TEXTURE_LOCATION, this.leftPos + 15, this.topPos + 16, 0, 171, (int)(healthProgress * 146.0f), 5);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String string = this.name.getValue();
        this.init(minecraft, width, height);
        this.name.setValue(string);
    }

    private void onNameChanged(String input) {
        if (!(input = input.trim()).equals(this.creeperMinion.getName().getString())) {
            this.creeperMinion.setCustomName((Component)Component.literal((String)input));
            MutantMonsters.NETWORK.sendToServer(new C2SCreeperMinionNameMessage((Entity)this.creeperMinion, input).toServerboundMessage());
        }
    }

    private static Component onOffComponent(Component component, boolean on) {
        return Component.empty().append(component).append(": ").append(on ? CommonComponents.OPTION_ON : CommonComponents.OPTION_OFF);
    }
}

