/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.events;

import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.corelib.death.DeathManager;
import de.maxhenkel.corpse.corelib.death.PlayerDeathEvent;
import de.maxhenkel.corpse.entities.CorpseEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;

public class DeathEvents {
    public DeathEvents() {
        de.maxhenkel.corpse.corelib.death.DeathEvents.register();
    }

    @SubscribeEvent
    public void playerDeath(PlayerDeathEvent event) {
        if ((Integer)Main.SERVER_CONFIG.maxDeathAge.get() != 0) {
            event.storeDeath();
        }
        event.removeDrops();
        ServerPlayer player = event.getPlayer();
        player.serverLevel().addFreshEntity((Entity)CorpseEntity.createFromDeath((Player)player, event.getDeath()));
        DeathEvents.deleteOldDeaths(player.serverLevel());
    }

    public static void deleteOldDeaths(ServerLevel serverWorld) {
        int ageInDays = (Integer)Main.SERVER_CONFIG.maxDeathAge.get();
        if (ageInDays < 0) {
            return;
        }
        long ageInMillis = (long)ageInDays * 24L * 60L * 60L * 1000L;
        new Thread(() -> DeathManager.removeDeathsOlderThan(serverWorld, ageInMillis)).start();
    }
}

