/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.core.util;

import dev.kosmx.playerAnim.core.util.Ease;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class Easing {
    @Deprecated
    public static float easingFromEnum(@Nullable Ease type, float f) {
        return type != null ? type.invoke(f) : f;
    }

    public static Ease easeFromString(String string) {
        try {
            if (string.substring(0, 4).equalsIgnoreCase("EASE")) {
                string = string.substring(4);
            }
            return Ease.valueOf(string.toUpperCase());
        }
        catch (Exception exception) {
            return Ease.LINEAR;
        }
    }

    public static float sine(float n) {
        return 1.0f - (float)Math.cos((double)n * Math.PI / 2.0);
    }

    public static float cubic(float n) {
        return n * n * n;
    }

    public static float quadratic(float n) {
        return n * n;
    }

    public static Function<Float, Float> pow(float n) {
        return t -> Float.valueOf((float)Math.pow(t.floatValue(), n));
    }

    public static float exp(float n) {
        return (float)Math.pow(2.0, 10.0f * (n - 1.0f));
    }

    public static float circle(float n) {
        return 1.0f - (float)Math.sqrt(1.0f - n * n);
    }

    public static Function<Float, Float> back(Float n) {
        float n2 = n == null ? 1.70158f : n.floatValue() * 1.70158f;
        return t -> Float.valueOf(t.floatValue() * t.floatValue() * ((n2 + 1.0f) * t.floatValue() - n2));
    }

    public static Function<Float, Float> elastic(Float n) {
        float n2 = n == null ? 1.0f : n.floatValue();
        return t -> Float.valueOf((float)(1.0 - Math.pow(Math.cos((double)t.floatValue() * Math.PI / 2.0), 3.0) * Math.cos((double)(t.floatValue() * n2) * Math.PI)));
    }

    public static Function<Float, Float> bounce(Float n) {
        float n2 = n == null ? 0.5f : n.floatValue();
        Function<Float, Float> one = x -> Float.valueOf(7.5625f * x.floatValue() * x.floatValue());
        Function<Float, Float> two = x -> Float.valueOf((float)((double)(30.25f * n2) * Math.pow(x.floatValue() - 0.54545456f, 2.0) + 1.0 - (double)n2));
        Function<Float, Float> three = x -> Float.valueOf((float)((double)(121.0f * n2 * n2) * Math.pow(x.floatValue() - 0.8181818f, 2.0) + 1.0 - (double)(n2 * n2)));
        Function<Float, Float> four = x -> Float.valueOf((float)((double)(484.0f * n2 * n2 * n2) * Math.pow(x.floatValue() - 0.95454544f, 2.0) + 1.0 - (double)(n2 * n2 * n2)));
        return t -> Float.valueOf(Math.min(Math.min(((Float)one.apply((Float)t)).floatValue(), ((Float)two.apply((Float)t)).floatValue()), Math.min(((Float)three.apply((Float)t)).floatValue(), ((Float)four.apply((Float)t)).floatValue())));
    }

    public static Function<Float, Float> step(Float n) {
        float n2;
        float f = n2 = n == null ? 2.0f : n.floatValue();
        if (n2 < 2.0f) {
            throw new IllegalArgumentException("Steps must be >= 2, got: " + n2);
        }
        int steps = (int)n2;
        return t -> {
            float f;
            float result = 0.0f;
            if (t.floatValue() < 0.0f) {
                return Float.valueOf(result);
            }
            float stepLength = 1.0f / (float)steps;
            result = (float)(steps - 1) * stepLength;
            if (t.floatValue() > f) {
                return Float.valueOf(result);
            }
            int leftBorderIndex = 0;
            int rightBorderIndex = steps - 1;
            while (rightBorderIndex - leftBorderIndex != 1) {
                int testIndex = leftBorderIndex + (rightBorderIndex - leftBorderIndex) / 2;
                if (t.floatValue() >= (float)testIndex * stepLength) {
                    leftBorderIndex = testIndex;
                    continue;
                }
                rightBorderIndex = testIndex;
            }
            return Float.valueOf((float)leftBorderIndex * stepLength);
        };
    }

    public static float catmullRom(float n) {
        return 0.5f * (2.0f * (n + 1.0f) + (n + 2.0f - n) * 1.0f + (2.0f * n - 5.0f * (n + 1.0f) + 4.0f * (n + 2.0f) - (n + 3.0f)) * 1.0f + (3.0f * (n + 1.0f) - n - 3.0f * (n + 2.0f) + (n + 3.0f)) * 1.0f);
    }
}

