/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.world.level.block.entity;

import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import fuzs.tradingpost.init.ModRegistry;
import fuzs.tradingpost.world.level.block.entity.TradingPostAnimationController;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TradingPostBlockEntity
extends BlockEntity
implements Nameable,
TickingBlockEntity {
    public static final Component CONTAINER_COMPONENT = Component.translatable((String)"container.trading_post");
    public static final String TAG_CUSTOM_NAME = "CustomName";
    private final TradingPostAnimationController animationController;
    @Nullable
    private Component name;

    public TradingPostBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModRegistry.TRADING_POST_BLOCK_ENTITY_TYPE.value(), blockPos, blockState);
        this.animationController = new TradingPostAnimationController(blockPos);
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider registries) {
        super.saveAdditional(compoundTag, registries);
        if (this.hasCustomName()) {
            compoundTag.putString(TAG_CUSTOM_NAME, Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)registries));
        }
    }

    public void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider registries) {
        super.loadAdditional(compoundTag, registries);
        if (compoundTag.contains(TAG_CUSTOM_NAME, 8)) {
            this.name = TradingPostBlockEntity.parseCustomNameSafe((String)compoundTag.getString(TAG_CUSTOM_NAME), (HolderLookup.Provider)registries);
        }
    }

    public void clientTick() {
        this.animationController.tick(this.getLevel());
    }

    public TradingPostAnimationController getAnimationController() {
        return this.animationController;
    }

    public Component getName() {
        return this.name != null ? this.name : CONTAINER_COMPONENT;
    }

    public void setCustomName(@Nullable Component component) {
        this.name = component;
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.name = (Component)componentInput.get(DataComponents.CUSTOM_NAME);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.CUSTOM_NAME, (Object)this.name);
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove(TAG_CUSTOM_NAME);
    }
}

