/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.world.level.block;

import com.mojang.serialization.MapCodec;
import fuzs.puzzleslib.api.block.v1.entity.TickingEntityBlock;
import fuzs.tradingpost.TradingPost;
import fuzs.tradingpost.config.ServerConfig;
import fuzs.tradingpost.init.ModRegistry;
import fuzs.tradingpost.mixin.accessor.VillagerAccessor;
import fuzs.tradingpost.world.entity.npc.MerchantCollection;
import fuzs.tradingpost.world.inventory.TradingPostMenu;
import fuzs.tradingpost.world.level.block.entity.TradingPostBlockEntity;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TradingPostBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
TickingEntityBlock<TradingPostBlockEntity> {
    public static final Component MISSING_MERCHANT_COMPONENT = Component.translatable((String)"trading_post.no_trader_found");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final MapCodec<TradingPostBlock> CODEC = TradingPostBlock.simpleCodec(TradingPostBlock::new);
    private static final VoxelShape LEG1 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)8.0, (double)4.0);
    private static final VoxelShape LEG2 = Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)4.0);
    private static final VoxelShape LEG3 = Block.box((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0, (double)16.0);
    private static final VoxelShape LEG4 = Block.box((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape TOP = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG1, LEG2, LEG3, LEG4});

    public TradingPostBlock(BlockBehaviour.Properties blockProperties) {
        super(blockProperties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState oldState, LevelAccessor level, BlockPos newPos, BlockPos oldPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(newPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, oldState, level, newPos, oldPos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(blockState);
    }

    public BlockEntityType<? extends TradingPostBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModRegistry.TRADING_POST_BLOCK_ENTITY_TYPE.value();
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        int verticalRange;
        int horizontalRange;
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        Vec3 atCenter = Vec3.atCenterOf((Vec3i)pos);
        List traders = level.getEntitiesOfClass(Entity.class, new AABB(atCenter.add((double)(-(horizontalRange = ((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).horizontalRange)), (double)(-(verticalRange = ((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).verticalRange)), (double)(-horizontalRange)), atCenter.add((double)horizontalRange, (double)verticalRange, (double)horizontalRange)), TradingPostBlock::isAllowedToTrade);
        if (!traders.isEmpty()) {
            Component title;
            ContainerLevelAccess access = ContainerLevelAccess.create((Level)level, (BlockPos)pos);
            MerchantCollection merchants = new MerchantCollection(access);
            for (Entity merchant : traders) {
                if (merchant instanceof Villager) {
                    ((VillagerAccessor)merchant).tradingpost$callUpdateSpecialPrices(player);
                }
                merchants.addMerchant(merchant.getId(), (Merchant)merchant);
            }
            merchants.setTradingPlayer(player);
            merchants.buildOffers(merchants.getIdToOfferCountMap());
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof TradingPostBlockEntity) {
                TradingPostBlockEntity blockEntity2 = (TradingPostBlockEntity)blockEntity;
                title = blockEntity2.getDisplayName();
            } else {
                title = TradingPostBlockEntity.CONTAINER_COMPONENT;
            }
            OptionalInt result = player.openMenu((MenuProvider)new SimpleMenuProvider((containerId, inventory, containerPlayer) -> new TradingPostMenu(containerId, inventory, merchants, access), title));
            result.ifPresent(containerId -> merchants.sendMerchantData(containerId, player));
        } else {
            player.displayClientMessage(MISSING_MERCHANT_COMPONENT, false);
        }
        return InteractionResult.CONSUME;
    }

    public static boolean isAllowedToTrade(Entity entity) {
        LivingEntity livingEntity;
        Merchant merchant;
        if (entity.getType().is(ModRegistry.EXCLUDE_FROM_TRADING_POST_ENTITY_TYPE_TAG)) {
            return false;
        }
        if (!entity.isAlive() || !(entity instanceof Merchant) || (merchant = (Merchant)entity).getTradingPlayer() != null || merchant.getOffers().isEmpty()) {
            return false;
        }
        return !(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).isSleeping() && !livingEntity.isBaby();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    public boolean isPathfindable(BlockState state, PathComputationType pathType) {
        return false;
    }
}

