/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.world.structures;

import com.kyanite.deeperdarker.DeeperDarker;
import com.kyanite.deeperdarker.util.DDTags;
import com.kyanite.deeperdarker.world.structures.DDPools;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;

public class DDStructures {
    public static final ResourceKey<Structure> ANCIENT_TEMPLE = DDStructures.createKey("ancient_temple");

    public static void bootstrap(BootstrapContext<Structure> context) {
        HolderGetter biomes = context.lookup(Registries.BIOME);
        HolderGetter pools = context.lookup(Registries.TEMPLATE_POOL);
        context.register(ANCIENT_TEMPLE, (Object)new JigsawStructure(DDStructures.structure((HolderSet<Biome>)biomes.getOrThrow(DDTags.Misc.HAS_ANCIENT_TEMPLE)), (Holder)pools.getOrThrow(DDPools.TEMPLE_START), 7, (HeightProvider)UniformHeight.of((VerticalAnchor)VerticalAnchor.aboveBottom((int)18), (VerticalAnchor)VerticalAnchor.aboveBottom((int)28)), false));
    }

    private static Structure.StructureSettings structure(HolderSet<Biome> biomes) {
        return new Structure.StructureSettings.Builder(biomes).generationStep(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).terrainAdapation(TerrainAdjustment.BEARD_BOX).build();
    }

    private static ResourceKey<Structure> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)DeeperDarker.rl(name));
    }
}

