/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.util.interval_tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import net.caffeinemc.mods.sodium.client.util.interval_tree.Interval;
import net.caffeinemc.mods.sodium.client.util.interval_tree.IntervalTree;

public class TreeNode<T extends Comparable<? super T>>
implements Iterable<Interval<T>> {
    protected final NavigableSet<Interval<T>> increasing;
    protected final NavigableSet<Interval<T>> decreasing = new TreeSet<Interval>(Interval.sweepRightToLeft);
    protected TreeNode<T> left;
    protected TreeNode<T> right;
    protected final T midpoint;
    protected int height;

    public TreeNode(Interval<T> interval) {
        this.increasing = new TreeSet<Interval>(Interval.sweepLeftToRight);
        this.decreasing.add(interval);
        this.increasing.add(interval);
        this.midpoint = interval.getMidpoint();
        this.height = 1;
    }

    public static <T extends Comparable<? super T>> TreeNode<T> addInterval(IntervalTree<T> tree, TreeNode<T> root, Interval<T> interval) {
        if (root == null) {
            ++tree.size;
            return new TreeNode<T>(interval);
        }
        if (interval.contains(root.midpoint)) {
            if (root.decreasing.add(interval)) {
                ++tree.size;
            }
            root.increasing.add(interval);
            return root;
        }
        if (interval.isLeftOf(root.midpoint)) {
            root.left = TreeNode.addInterval(tree, root.left, interval);
            root.height = Math.max(TreeNode.height(root.left), TreeNode.height(root.right)) + 1;
        } else {
            root.right = TreeNode.addInterval(tree, root.right, interval);
            root.height = Math.max(TreeNode.height(root.left), TreeNode.height(root.right)) + 1;
        }
        return root.balanceOut();
    }

    public int height() {
        return this.height;
    }

    private static int height(TreeNode node) {
        return node == null ? 0 : node.height();
    }

    private TreeNode<T> balanceOut() {
        int balance = TreeNode.height(this.left) - TreeNode.height(this.right);
        if (balance < -1) {
            if (TreeNode.height(this.right.left) > TreeNode.height(this.right.right)) {
                this.right = this.right.rightRotate();
                return this.leftRotate();
            }
            return this.leftRotate();
        }
        if (balance > 1) {
            if (TreeNode.height(this.left.right) > TreeNode.height(this.left.left)) {
                this.left = this.left.leftRotate();
                return this.rightRotate();
            }
            return this.rightRotate();
        }
        return this;
    }

    private TreeNode<T> leftRotate() {
        TreeNode<T> head = this.right;
        this.right = head.left;
        head.left = this;
        this.height = Math.max(TreeNode.height(this.right), TreeNode.height(this.left)) + 1;
        head.left = head.assimilateOverlappingIntervals(this);
        return head;
    }

    private TreeNode<T> rightRotate() {
        TreeNode<T> head = this.left;
        this.left = head.right;
        head.right = this;
        this.height = Math.max(TreeNode.height(this.right), TreeNode.height(this.left)) + 1;
        head.right = head.assimilateOverlappingIntervals(this);
        return head;
    }

    private TreeNode<T> assimilateOverlappingIntervals(TreeNode<T> from) {
        ArrayList<Interval> tmp = new ArrayList<Interval>();
        if (this.midpoint.compareTo(from.midpoint) < 0) {
            for (Interval<T> next : from.increasing) {
                if (next.isRightOf(this.midpoint)) break;
                tmp.add(next);
            }
        } else {
            for (Interval<T> next : from.decreasing) {
                if (next.isLeftOf(this.midpoint)) break;
                tmp.add(next);
            }
        }
        tmp.forEach(from.increasing::remove);
        tmp.forEach(from.decreasing::remove);
        this.increasing.addAll(tmp);
        this.decreasing.addAll(tmp);
        if (from.increasing.isEmpty()) {
            return TreeNode.deleteNode(from);
        }
        return from;
    }

    public static <T extends Comparable<? super T>> TreeNode<T> removeInterval(IntervalTree<T> tree, TreeNode<T> root, Interval<T> interval) {
        if (root == null) {
            return null;
        }
        if (interval.contains(root.midpoint)) {
            if (root.decreasing.remove(interval)) {
                --tree.size;
            }
            root.increasing.remove(interval);
            if (root.increasing.isEmpty()) {
                return TreeNode.deleteNode(root);
            }
        } else if (interval.isLeftOf(root.midpoint)) {
            root.left = TreeNode.removeInterval(tree, root.left, interval);
        } else {
            root.right = TreeNode.removeInterval(tree, root.right, interval);
        }
        return root.balanceOut();
    }

    private static <T extends Comparable<? super T>> TreeNode<T> deleteNode(TreeNode<T> root) {
        if (root.left == null && root.right == null) {
            return null;
        }
        if (root.left == null) {
            return root.right;
        }
        TreeNode node = root.left;
        Stack<TreeNode> stack = new Stack<TreeNode>();
        while (node.right != null) {
            stack.push(node);
            node = node.right;
        }
        if (!stack.isEmpty()) {
            ((TreeNode)stack.peek()).right = node.left;
            node.left = root.left;
        }
        node.right = root.right;
        TreeNode newRoot = node;
        while (!stack.isEmpty()) {
            node = (TreeNode)stack.pop();
            if (!stack.isEmpty()) {
                ((TreeNode)stack.peek()).right = newRoot.assimilateOverlappingIntervals(node);
                continue;
            }
            newRoot.left = newRoot.assimilateOverlappingIntervals(node);
        }
        return newRoot.balanceOut();
    }

    static <T extends Comparable<? super T>> void rangeQueryLeft(TreeNode<T> node, Interval<T> query, Set<Interval<T>> result) {
        while (node != null) {
            if (query.contains(node.midpoint)) {
                result.addAll(node.increasing);
                if (node.right != null) {
                    for (Interval interval : node.right) {
                        result.add(interval);
                    }
                }
                node = node.left;
                continue;
            }
            for (Interval<T> interval : node.decreasing) {
                if (interval.isLeftOf(query)) break;
                result.add(interval);
            }
            node = node.right;
        }
    }

    static <T extends Comparable<? super T>> void rangeQueryRight(TreeNode<T> node, Interval<T> query, Set<Interval<T>> result) {
        while (node != null) {
            if (query.contains(node.midpoint)) {
                result.addAll(node.increasing);
                if (node.left != null) {
                    for (Interval interval : node.left) {
                        result.add(interval);
                    }
                }
                node = node.right;
                continue;
            }
            for (Interval<T> interval : node.increasing) {
                if (interval.isRightOf(query)) break;
                result.add(interval);
            }
            node = node.left;
        }
    }

    public TreeNodeIterator iterator() {
        return new TreeNodeIterator();
    }

    class TreeNodeIterator
    implements Iterator<Interval<T>> {
        Stack<TreeNode<T>> stack = new Stack();
        TreeNode<T> subtreeRoot = TreeNode.this;
        TreeNode<T> currentNode;
        Interval<T> currentInterval;
        Iterator<Interval<T>> iterator = Collections.emptyIterator();

        TreeNodeIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.subtreeRoot != null || !this.stack.isEmpty() || this.iterator.hasNext();
        }

        @Override
        public Interval<T> next() {
            if (!this.iterator.hasNext()) {
                while (this.subtreeRoot != null) {
                    this.stack.push(this.subtreeRoot);
                    this.subtreeRoot = this.subtreeRoot.left;
                }
                if (this.stack.isEmpty()) {
                    throw new NoSuchElementException();
                }
                this.currentNode = this.stack.pop();
                this.iterator = this.currentNode.increasing.iterator();
                this.subtreeRoot = this.currentNode.right;
            }
            this.currentInterval = this.iterator.next();
            return this.currentInterval;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

