/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.util;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.Constants;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class NeoForgeConfigHelper {
    private static final Method MOD_CONFIG_OPEN_CONFIG = ObfuscationReflectionHelper.findMethod(ConfigTracker.class, (String)"openConfig", (Class[])new Class[]{ModConfig.class, Path.class, Path.class});
    private static final Method MOD_CONFIG_CLOSE_CONFIG = ObfuscationReflectionHelper.findMethod(ConfigTracker.class, (String)"unloadConfig", (Class[])new Class[]{ModConfig.class});
    private static final Field MOD_CONFIG_LOADED_CONFIG = ObfuscationReflectionHelper.findField(ModConfig.class, (String)"loadedConfig");
    private static final Field MOD_CONFIG_LOCK = ObfuscationReflectionHelper.findField(ModConfig.class, (String)"lock");

    public static List<Pair<ModConfigSpec.ConfigValue<?>, ModConfigSpec.ValueSpec>> gatherAllConfigValues(UnmodifiableConfig config, ModConfigSpec spec) {
        ArrayList values = new ArrayList();
        NeoForgeConfigHelper.gatherValuesFromModConfig(config, spec, values);
        return ImmutableList.copyOf(values);
    }

    private static void gatherValuesFromModConfig(UnmodifiableConfig config, ModConfigSpec spec, List<Pair<ModConfigSpec.ConfigValue<?>, ModConfigSpec.ValueSpec>> values) {
        config.valueMap().forEach((s, o) -> {
            if (o instanceof AbstractConfig) {
                NeoForgeConfigHelper.gatherValuesFromModConfig((UnmodifiableConfig)o, spec, values);
            } else if (o instanceof ModConfigSpec.ConfigValue) {
                ModConfigSpec.ConfigValue configValue = (ModConfigSpec.ConfigValue)o;
                ModConfigSpec.ValueSpec valueSpec = (ModConfigSpec.ValueSpec)spec.getSpec().getRaw(configValue.getPath());
                values.add(Pair.of((Object)configValue, (Object)valueSpec));
            }
        });
    }

    @Nullable
    public static IConfigSpec.ILoadedConfig getLoadedConfig(ModConfig config) {
        try {
            return (IConfigSpec.ILoadedConfig)MOD_CONFIG_LOADED_CONFIG.get(config);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static CommentedConfig getConfigData(ModConfig config) {
        IConfigSpec.ILoadedConfig data = NeoForgeConfigHelper.getLoadedConfig(config);
        if (data != null) {
            return data.config();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void wrapLock(ModConfig config, Runnable task) {
        Lock lock;
        try {
            lock = (Lock)MOD_CONFIG_LOCK.get(config);
        }
        catch (IllegalAccessException e) {
            Constants.LOG.error("Failed to acquire lock when setting config data");
            return;
        }
        lock.lock();
        try {
            task.run();
        }
        finally {
            lock.unlock();
        }
    }

    public static void setConfigData(ModConfig config, @Nullable CommentedConfig configData) {
        IConfigSpec.ILoadedConfig loadedConfig = NeoForgeConfigHelper.getLoadedConfig(config);
        if (loadedConfig != null) {
            CommentedConfig data = loadedConfig.config();
            NeoForgeConfigHelper.wrapLock(config, () -> {
                data.putAll((UnmodifiableConfig)configData);
                NeoForgeConfigHelper.correctConfig(config, data);
            });
            NeoForgeConfigHelper.resetConfigCache(config);
            loadedConfig.save();
        }
    }

    @Nullable
    public static ModConfig getModConfig(String fileName) {
        ConcurrentHashMap configMap = (ConcurrentHashMap)ObfuscationReflectionHelper.getPrivateValue(ConfigTracker.class, (Object)ConfigTracker.INSTANCE, (String)"fileMap");
        return configMap != null ? (ModConfig)configMap.get(fileName) : null;
    }

    public static List<Pair<ModConfigSpec.ConfigValue<?>, ModConfigSpec.ValueSpec>> gatherAllConfigValues(ModConfig config) {
        return NeoForgeConfigHelper.gatherAllConfigValues(((ModConfigSpec)config.getSpec()).getValues(), (ModConfigSpec)config.getSpec());
    }

    public static void closeConfig(ModConfig config) {
        try {
            MOD_CONFIG_CLOSE_CONFIG.invoke((Object)ConfigTracker.INSTANCE, config);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void openConfig(ModConfig config, Path path) {
        try {
            MOD_CONFIG_OPEN_CONFIG.invoke((Object)ConfigTracker.INSTANCE, config, path, null);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveConfig(ModConfig config) {
        IConfigSpec.ILoadedConfig loadedConfig = NeoForgeConfigHelper.getLoadedConfig(config);
        if (loadedConfig != null) {
            loadedConfig.save();
        }
    }

    public static void resetConfigCache(ModConfig config) {
        IConfigSpec iConfigSpec = config.getSpec();
        if (iConfigSpec instanceof ModConfigSpec) {
            ModConfigSpec spec = (ModConfigSpec)iConfigSpec;
            spec.afterReload();
        }
    }

    public static void correctConfig(ModConfig config, CommentedConfig data) {
        IConfigSpec spec = config.getSpec();
        if (!spec.isCorrect((UnmodifiableCommentedConfig)data)) {
            spec.correct(data);
        }
    }

    static {
        MOD_CONFIG_OPEN_CONFIG.setAccessible(true);
        MOD_CONFIG_CLOSE_CONFIG.setAccessible(true);
        MOD_CONFIG_LOADED_CONFIG.setAccessible(true);
        MOD_CONFIG_LOCK.setAccessible(true);
    }
}

