/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.configured.client.screen.widget.ConfiguredButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class IconButton
extends ConfiguredButton {
    public static final ResourceLocation ICONS = ResourceLocation.fromNamespaceAndPath((String)"configured", (String)"textures/gui/icons.png");
    private final Component label;
    private final int u;
    private final int v;

    public IconButton(int x, int y, int u, int v, Button.OnPress onPress) {
        this(x, y, u, v, 20, CommonComponents.EMPTY, onPress);
    }

    public IconButton(int x, int y, int u, int v, int width, Component label, Button.OnPress onPress) {
        super(x, y, width, 20, CommonComponents.EMPTY, onPress, DEFAULT_NARRATION);
        this.label = label;
        this.u = u;
        this.v = v;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        float brightness;
        boolean renderIcon;
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        Minecraft mc = Minecraft.getInstance();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int contentWidth = 10 + mc.font.width((FormattedText)this.label) + (!this.label.getString().isEmpty() ? 4 : 0);
        boolean bl = renderIcon = contentWidth <= this.width;
        if (!renderIcon) {
            contentWidth = mc.font.width((FormattedText)this.label);
        }
        int iconX = this.getX() + (this.width - contentWidth) / 2;
        int iconY = this.getY() + 5;
        float f = brightness = this.active ? 1.0f : 0.5f;
        if (renderIcon) {
            RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)this.alpha);
            graphics.blit(ICONS, iconX, iconY, 0, (float)this.u, (float)this.v, 11, 11, 64, 64);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        int textColor = (this.active ? 0xFFFFFF : 0xA0A0A0) | Mth.ceil((float)(this.alpha * 255.0f)) << 24;
        graphics.drawString(mc.font, this.label, iconX + 14, iconY + 1, textColor);
    }

    protected MutableComponent createNarrationMessage() {
        return IconButton.wrapDefaultNarrationMessage((Component)this.label);
    }
}

