/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client;

import com.mojang.datafixers.util.Either;
import com.mrcrayfish.configured.client.ClientHandler;
import com.mrcrayfish.configured.client.EditingTracker;
import com.mrcrayfish.configured.client.screen.TooltipScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.gui.ModListScreen;

@EventBusSubscriber(modid="configured", value={Dist.CLIENT})
public class NeoForgeClientEvents {
    @SubscribeEvent
    private static void onKeyPress(InputEvent.Key event) {
        if (event.getAction() == 1 && ClientHandler.KEY_OPEN_MOD_LIST.isDown()) {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.player == null) {
                return;
            }
            Screen oldScreen = minecraft.screen;
            minecraft.setScreen((Screen)new ModListScreen(oldScreen));
        }
    }

    @SubscribeEvent
    private static void onGatherTooltipComponents(RenderTooltipEvent.GatherComponents event) {
        Minecraft minecraft = Minecraft.getInstance();
        Screen screen = minecraft.screen;
        if (!(screen instanceof TooltipScreen)) {
            return;
        }
        TooltipScreen screen2 = (TooltipScreen)screen;
        if (screen2.tooltipText == null) {
            return;
        }
        event.getTooltipElements().clear();
        for (FormattedCharSequence text : screen2.tooltipText) {
            event.getTooltipElements().add(Either.right((Object)new TooltipScreen.ListMenuTooltipComponent(text)));
        }
    }

    @SubscribeEvent
    private static void onGetTooltipColor(RenderTooltipEvent.Color event) {
        Minecraft minecraft = Minecraft.getInstance();
        Screen screen = minecraft.screen;
        if (!(screen instanceof TooltipScreen)) {
            return;
        }
        TooltipScreen screen2 = (TooltipScreen)screen;
        if (screen2.tooltipText == null) {
            return;
        }
        if (screen2.tooltipOutlineColour == null) {
            return;
        }
        event.setBorderStart(screen2.tooltipOutlineColour.intValue());
        event.setBorderEnd(screen2.tooltipOutlineColour.intValue());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onScreenOpen(ScreenEvent.Opening event) {
        EditingTracker.instance().onScreenOpen(event.getScreen());
    }
}

