/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.shulkerbox.menu;

import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.SeededContainerLoot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class AdvancedShulkerboxContainer
implements Container {
    protected NonNullList<ItemStack> items;
    protected ItemStack shulkerBox;
    protected int invSize;

    public AdvancedShulkerboxContainer(@Nullable ServerPlayer player, ItemStack shulkerBox, int invSize) {
        SeededContainerLoot loot;
        this.shulkerBox = shulkerBox;
        this.invSize = invSize;
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ItemContainerContents contents = (ItemContainerContents)shulkerBox.get(DataComponents.CONTAINER);
        if (contents != null) {
            contents.copyInto(this.items);
        }
        if ((loot = (SeededContainerLoot)shulkerBox.get(DataComponents.CONTAINER_LOOT)) != null) {
            this.fillWithLoot(player, loot);
            shulkerBox.remove(DataComponents.CONTAINER_LOOT);
        }
    }

    public void fillWithLoot(@Nullable ServerPlayer player, SeededContainerLoot loot) {
        if (player == null) {
            return;
        }
        LootTable loottable = player.server.reloadableRegistries().getLootTable(loot.lootTable());
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)player.level());
        builder.withLuck(player.getLuck()).withParameter(LootContextParams.THIS_ENTITY, (Object)player);
        loottable.fill((Container)this, builder.create(LootContextParamSets.CHEST), loot.seed());
        this.setChanged();
    }

    public int getContainerSize() {
        return this.invSize;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack itemstack = ContainerHelper.removeItem(this.items, (int)index, (int)count);
        this.setChanged();
        return itemstack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = ContainerHelper.takeItem(this.items, (int)index);
        this.setChanged();
        return stack;
    }

    public void setItem(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        this.setChanged();
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void setChanged() {
        this.shulkerBox.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.items));
    }

    public void startOpen(Player player) {
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), this.getOpenSound(), SoundSource.BLOCKS, 0.5f, AdvancedShulkerboxContainer.getVariatedPitch(player.level()));
    }

    public void stopOpen(Player player) {
        this.setChanged();
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), this.getCloseSound(), SoundSource.BLOCKS, 0.5f, AdvancedShulkerboxContainer.getVariatedPitch(player.level()));
    }

    protected static float getVariatedPitch(Level world) {
        return world.random.nextFloat() * 0.1f + 0.9f;
    }

    protected SoundEvent getOpenSound() {
        return SoundEvents.SHULKER_BOX_OPEN;
    }

    protected SoundEvent getCloseSound() {
        return SoundEvents.SHULKER_BOX_CLOSE;
    }

    public void clearContent() {
        this.items.clear();
        this.setChanged();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean stillValid(Player player) {
        return player.getInventory().contains(this.shulkerBox);
    }
}

