/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.platform;

import io.github.flemmli97.mobbattle.MobBattle;
import io.github.flemmli97.mobbattle.common.components.AreaPositionComponent;
import io.github.flemmli97.mobbattle.common.components.EffectComponent;
import io.github.flemmli97.mobbattle.common.components.SpawnEggOptions;
import io.github.flemmli97.mobbattle.common.components.UuidComponent;
import io.github.flemmli97.mobbattle.common.components.UuidListComponent;
import io.github.flemmli97.mobbattle.common.inv.ContainerArmor;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public interface CrossPlatformStuff {
    public static final TagKey<EntityType<?>> MULTIPART_ENTITY = TagKey.create((ResourceKey)BuiltInRegistries.ENTITY_TYPE.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"multipart_entity"));
    public static final CrossPlatformStuff INSTANCE = MobBattle.getPlatformInstance(CrossPlatformStuff.class, "io.github.flemmli97.mobbattle.fabric.platform.CrossPlatformStuffImpl", "io.github.flemmli97.mobbattle.neoforge.platform.CrossPlatformStuffImpl");

    public MenuType<ContainerArmor> getArmorMenuType();

    public DataComponentType<UuidComponent> getComponentMobUuid();

    public DataComponentType<UuidListComponent> getComponentMobGroupUuid();

    public DataComponentType<EffectComponent> getComponentEffect();

    public DataComponentType<AreaPositionComponent> getComponentAreaSelection();

    public DataComponentType<SpawnEggOptions> getComponentSpawnEggOptions();

    default public LivingEntity tryGetEntity(Entity entity) {
        LivingEntity mob;
        if (entity instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)entity;
            if (entity.getType().is(MULTIPART_ENTITY)) {
                return ownable.getOwner();
            }
        }
        if (entity instanceof TraceableEntity) {
            Entity entity2;
            TraceableEntity traceableEntity = (TraceableEntity)entity;
            if (entity.getType().is(MULTIPART_ENTITY) && (entity2 = traceableEntity.getOwner()) instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity2;
                return owner;
            }
        }
        if (entity instanceof EnderDragonPart) {
            EnderDragonPart part = (EnderDragonPart)entity;
            return part.parentMob;
        }
        return entity instanceof LivingEntity ? (mob = (LivingEntity)entity) : null;
    }

    public void openGuiArmor(ServerPlayer var1, Mob var2);

    public boolean canEquip(ItemStack var1, EquipmentSlot var2, LivingEntity var3);

    public GoalSelector goalSelectorFrom(Mob var1, boolean var2);

    public void sendToClient(CustomPacketPayload var1, ServerPlayer var2);

    public void sendToServer(CustomPacketPayload var1);
}

