/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.neoforge;

import io.github.flemmli97.mobbattle.MobBattle;
import io.github.flemmli97.mobbattle.common.items.ItemExtendedSpawnEgg;
import io.github.flemmli97.mobbattle.neoforge.ConfigLoader;
import io.github.flemmli97.mobbattle.neoforge.client.ClientEvents;
import io.github.flemmli97.mobbattle.neoforge.handler.EventHandler;
import io.github.flemmli97.mobbattle.neoforge.registry.ModComponents;
import io.github.flemmli97.mobbattle.neoforge.registry.ModItems;
import io.github.flemmli97.mobbattle.neoforge.registry.ModMenuType;
import io.github.flemmli97.mobbattle.network.C2SEffectStack;
import io.github.flemmli97.mobbattle.network.C2SSpawnEgg;
import io.github.flemmli97.mobbattle.network.S2CSpawnEggScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="mobbattle")
public class MobBattleNeoForge {
    private static final DeferredRegister<CreativeModeTab> TAB_REGISTER = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"mobbattle");

    public MobBattleNeoForge(IEventBus modBus) {
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.CLIENT, ConfigLoader.CLIENT_SPEC, "mobbattle-client.toml");
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.COMMON, ConfigLoader.COMMON_SPEC, "mobbattle.toml");
        NeoForge.EVENT_BUS.register((Object)new EventHandler());
        modBus.addListener(MobBattleNeoForge::preInit);
        modBus.addListener(MobBattleNeoForge::creativeTabContents);
        modBus.addListener(MobBattleNeoForge::registerPackets);
        modBus.addListener(MobBattleNeoForge::confLoad);
        modBus.addListener(MobBattleNeoForge::confReload);
        ModItems.ITEMS.register(modBus);
        ModMenuType.MENU_TYPE.register(modBus);
        ModComponents.COMPONENTS.register(modBus);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientEvents.register(modBus);
        }
        MobBattle.tenshiLib = ModList.get().isLoaded("tenshilib");
        MobBattle.customTab = TAB_REGISTER.register("tab", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)ModItems.MOB_STICK.get())).title((Component)Component.translatable((String)"mobbattle.tab")).build());
        TAB_REGISTER.register(modBus);
    }

    public static void preInit(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> DispenserBlock.registerBehavior((ItemLike)((ItemLike)ModItems.EXTENDED_EGG.get()), (source, stack) -> {
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            double x = source.center().x() + (double)direction.getStepX();
            double y = (double)(source.pos().getY() + direction.getStepY()) + 0.2;
            double z = source.center().z() + (double)direction.getStepZ();
            BlockPos blockpos = BlockPos.containing((double)x, (double)y, (double)z);
            boolean spawned = ItemExtendedSpawnEgg.spawnEntity(source.level(), stack, (double)blockpos.getX() + 0.5, blockpos.getY(), (double)blockpos.getZ() + 0.5, direction);
            if (spawned) {
                stack.shrink(1);
            }
            return stack;
        }));
    }

    public static void creativeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == MobBattle.customTab.get()) {
            ModItems.ITEMS.getEntries().forEach(holder -> event.accept((ItemLike)holder.get()));
        }
    }

    public static void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("mobbattle");
        registrar.playToServer(C2SEffectStack.TYPE, C2SEffectStack.STREAM_CODEC, (pkt, ctx) -> ctx.enqueueWork(() -> C2SEffectStack.handle(pkt, ctx.player(), (Item)ModItems.MOB_EFFECT_GIVE.get())));
        registrar.playToServer(C2SSpawnEgg.TYPE, C2SSpawnEgg.STREAM_CODEC, (pkt, ctx) -> ctx.enqueueWork(() -> C2SSpawnEgg.handle(pkt, ctx.player())));
        registrar.playToClient(S2CSpawnEggScreen.TYPE, S2CSpawnEggScreen.STREAM_CODEC, (pkt, ctx) -> ctx.enqueueWork(() -> S2CSpawnEggScreen.handle(pkt)));
    }

    public static void confLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == ConfigLoader.CLIENT_SPEC) {
            ConfigLoader.CLIENT_CONF.reload();
        }
        if (event.getConfig().getSpec() == ConfigLoader.COMMON_SPEC) {
            ConfigLoader.COMMON_CONF.reload();
        }
    }

    public static void confReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == ConfigLoader.CLIENT_SPEC) {
            ConfigLoader.CLIENT_CONF.reload();
        }
        if (event.getConfig().getSpec() == ConfigLoader.COMMON_SPEC) {
            ConfigLoader.COMMON_CONF.reload();
        }
    }
}

