/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.common.utils;

import io.github.flemmli97.mobbattle.MobBattle;
import io.github.flemmli97.mobbattle.common.entity.ai.EntityAIHurt;
import io.github.flemmli97.mobbattle.common.entity.ai.EntityAITeamTarget;
import io.github.flemmli97.mobbattle.common.utils.ActiveTargetMobbattle;
import io.github.flemmli97.mobbattle.platform.CrossPlatformStuff;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.joml.Vector3f;

public class Utils {
    public static Map<ChatFormatting, DustParticleOptions> teamColor = new HashMap<ChatFormatting, DustParticleOptions>();
    public static final ResourceLocation MOB_BATTLE_FOLLOW_MOD = ResourceLocation.fromNamespaceAndPath((String)"mobbattle", (String)"follow_target_mod");
    private static final Predicate<Goal> targetGoal;

    public static String getTeam(Entity entity) {
        return entity.getTeam() != null ? entity.getTeam().getName() : "none";
    }

    public static boolean isOnSameTeam(Entity entity, Entity entity2) {
        if (entity.getTeam() != null && entity2.getTeam() != null) {
            return entity.isAlliedTo(entity2);
        }
        return false;
    }

    public static boolean canTargetEntity(Entity entity, Entity entity2) {
        if (entity.getTeam() == null || entity2.getTeam() == null) {
            return false;
        }
        return !entity.isAlliedTo(entity2);
    }

    public static void addEntityToTeam(Entity entity, String team) {
        Scoreboard score = entity.level().getScoreboard();
        PlayerTeam scoreTeam = score.getPlayerTeam(team);
        if (scoreTeam == null) {
            scoreTeam = score.addPlayerTeam(team);
            scoreTeam.setCollisionRule(Team.CollisionRule.PUSH_OTHER_TEAMS);
        }
        score.getPlayerTeam(team).getPlayers().size();
        score.addPlayerToTeam(entity.getStringUUID(), scoreTeam);
    }

    public static int getTeamSize(Entity entity, String team) {
        return entity.level().getScoreboard().getPlayerTeam(team) != null ? entity.level().getScoreboard().getPlayerTeam(team).getPlayers().size() : 0;
    }

    public static void updateEntity(String team, Mob e) {
        team = team.replace(" ", "");
        Utils.addEntityToTeam((Entity)e, team);
        e.setTarget(null);
        e.addTag("mobbattle:AddedAI");
        if (e.getType().is(MobBattle.IGNORED)) {
            return;
        }
        Utils.removeGoal(CrossPlatformStuff.INSTANCE.goalSelectorFrom(e, true), targetGoal);
        CrossPlatformStuff.INSTANCE.goalSelectorFrom(e, true).addGoal(0, (Goal)new EntityAIHurt(e));
        CrossPlatformStuff.INSTANCE.goalSelectorFrom(e, true).addGoal(3, (Goal)new EntityAITeamTarget(e, false, true));
    }

    private static void removeGoal(GoalSelector goalSel, Predicate<Goal> pred) {
        Set<WrappedGoal> goals = goalSel.getAvailableGoals().stream().filter(prio -> pred.test(prio.getGoal())).collect(Collectors.toSet());
        goals.forEach(arg_0 -> ((GoalSelector)goalSel).removeGoal(arg_0));
    }

    public static AABB getBoundingBoxPositions(BlockPos pos, BlockPos pos2) {
        if (pos2 == null) {
            return new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).move(pos);
        }
        int xDiff = pos.getX() - pos2.getX();
        int yDiff = pos.getY() - pos2.getY();
        int zDiff = pos.getZ() - pos2.getZ();
        int z2 = 0;
        int y2 = 0;
        int x2 = 0;
        int z = 0;
        int y = 0;
        int x = 0;
        if (xDiff <= 0) {
            x = 1;
        } else {
            x2 = 1;
        }
        if (yDiff <= 0) {
            y = 1;
        } else {
            y2 = 1;
        }
        if (zDiff <= 0) {
            z = 1;
        } else {
            z2 = 1;
        }
        return new AABB((double)x, (double)y, (double)z, (double)(xDiff + x2), (double)(yDiff + y2), (double)(zDiff + z2)).move(pos2);
    }

    public static Mob fromUUID(ServerLevel world, UUID uuid) {
        Entity e;
        if (uuid != null && (e = world.getEntity(uuid)) instanceof Mob) {
            return (Mob)e;
        }
        return null;
    }

    public static void setAttackTarget(Mob entity, LivingEntity target, boolean both) {
        if (target == null) {
            return;
        }
        Utils.setTargetTo(entity, target);
        Utils.increaseFollow(entity);
        if (target instanceof Mob) {
            Mob mobTarget = (Mob)target;
            if (both) {
                Utils.increaseFollow(mobTarget);
                Utils.setTargetTo(mobTarget, (LivingEntity)entity);
            }
        }
    }

    private static void increaseFollow(Mob mob) {
        AttributeInstance att = mob.getAttribute(Attributes.FOLLOW_RANGE);
        if (att != null && !att.hasModifier(MOB_BATTLE_FOLLOW_MOD)) {
            att.addTransientModifier(new AttributeModifier(MOB_BATTLE_FOLLOW_MOD, 64.0, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    private static void setTargetTo(Mob entity, LivingEntity target) {
        entity.setTarget(target);
        entity.getBrain().setMemory(MemoryModuleType.ANGRY_AT, (Object)target.getUUID());
        entity.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)target);
        if (entity instanceof Warden) {
            Warden warden = (Warden)entity;
            warden.increaseAngerAt((Entity)target, AngerLevel.ANGRY.getMinimumAnger() + 20, false);
            warden.setAttackTarget(target);
        }
        if (entity instanceof ActiveTargetMobbattle) {
            ActiveTargetMobbattle act = (ActiveTargetMobbattle)entity;
            act.mobbattle$setTargeting(true);
        }
    }

    public static void handleTeamKill(Scoreboard scoreboard, ScoreHolder scoreHolder, ScoreHolder teamMember, ObjectiveCriteria[] crtieria) {
        int i;
        PlayerTeam playerTeam = scoreboard.getPlayersTeam(teamMember.getScoreboardName());
        if (playerTeam != null && (i = playerTeam.getColor().getId()) >= 0 && i < crtieria.length) {
            scoreboard.forAllObjectives(crtieria[i], scoreHolder, ScoreAccess::increment);
        }
    }

    static {
        teamColor.put(ChatFormatting.AQUA, new DustParticleOptions(new Vector3f(0.01f, 0.9f, 1.0f), 1.0f));
        teamColor.put(ChatFormatting.BLACK, new DustParticleOptions(new Vector3f(0.01f, 0.0f, 0.0f), 1.0f));
        teamColor.put(ChatFormatting.BLUE, new DustParticleOptions(new Vector3f(0.2f, 0.2f, 1.0f), 1.0f));
        teamColor.put(ChatFormatting.DARK_AQUA, new DustParticleOptions(new Vector3f(0.01f, 0.4f, 0.5f), 1.0f));
        teamColor.put(ChatFormatting.DARK_BLUE, new DustParticleOptions(new Vector3f(0.01f, 0.0f, 0.4f), 1.0f));
        teamColor.put(ChatFormatting.DARK_GRAY, new DustParticleOptions(new Vector3f(0.2f, 0.2f, 0.2f), 1.0f));
        teamColor.put(ChatFormatting.DARK_GREEN, new DustParticleOptions(new Vector3f(0.01f, 0.5f, 0.0f), 1.0f));
        teamColor.put(ChatFormatting.DARK_PURPLE, new DustParticleOptions(new Vector3f(0.3f, 0.0f, 0.4f), 1.0f));
        teamColor.put(ChatFormatting.DARK_RED, new DustParticleOptions(new Vector3f(0.5f, 0.0f, 0.0f), 1.0f));
        teamColor.put(ChatFormatting.GOLD, new DustParticleOptions(new Vector3f(1.0f, 0.6f, 0.0f), 1.0f));
        teamColor.put(ChatFormatting.GRAY, new DustParticleOptions(new Vector3f(0.4f, 0.4f, 0.4f), 1.0f));
        teamColor.put(ChatFormatting.GREEN, new DustParticleOptions(new Vector3f(0.01f, 1.0f, 0.0f), 1.0f));
        teamColor.put(ChatFormatting.LIGHT_PURPLE, new DustParticleOptions(new Vector3f(0.6f, 0.0f, 0.7f), 1.0f));
        teamColor.put(ChatFormatting.RED, new DustParticleOptions(new Vector3f(1.0f, 0.2f, 0.2f), 1.0f));
        teamColor.put(ChatFormatting.WHITE, new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f));
        teamColor.put(ChatFormatting.YELLOW, new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 1.0f));
        targetGoal = goal -> true;
    }
}

