/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.common.items;

import io.github.flemmli97.mobbattle.common.components.UuidComponent;
import io.github.flemmli97.mobbattle.common.items.LeftClickInteractItem;
import io.github.flemmli97.mobbattle.common.utils.Utils;
import io.github.flemmli97.mobbattle.platform.CrossPlatformStuff;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class MobStick
extends Item
implements LeftClickInteractItem {
    public MobStick(Item.Properties props) {
        super(props);
    }

    public boolean canAttackBlock(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag b) {
        UuidComponent comp = (UuidComponent)stack.get(CrossPlatformStuff.INSTANCE.getComponentMobUuid());
        if (comp != null && comp.name().isPresent()) {
            list.add((Component)Component.translatable((String)"tooltip.stick.contains", (Object[])new Object[]{comp.name()}).withStyle(ChatFormatting.GREEN));
        }
        list.add((Component)Component.translatable((String)"tooltip.stick.first").withStyle(ChatFormatting.AQUA));
        list.add((Component)Component.translatable((String)"tooltip.stick.second").withStyle(ChatFormatting.AQUA));
    }

    public boolean isFoil(ItemStack stack) {
        UuidComponent comp = (UuidComponent)stack.get(CrossPlatformStuff.INSTANCE.getComponentMobUuid());
        return comp != null && comp.uuid().isPresent();
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        UuidComponent comp;
        ItemStack stack = player.getItemInHand(hand);
        if (!player.level().isClientSide && (comp = (UuidComponent)stack.get(CrossPlatformStuff.INSTANCE.getComponentMobUuid())) != null) {
            stack.remove(CrossPlatformStuff.INSTANCE.getComponentMobUuid());
            player.sendSystemMessage((Component)Component.translatable((String)"tooltip.stick.reset").withStyle(ChatFormatting.RED));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (player.level() instanceof ServerLevel) {
            UuidComponent comp = (UuidComponent)stack.get(CrossPlatformStuff.INSTANCE.getComponentMobUuid());
            LivingEntity living = CrossPlatformStuff.INSTANCE.tryGetEntity(entity);
            if (!(living instanceof Mob)) {
                return true;
            }
            Mob target = (Mob)living;
            if (comp != null && comp.uuid().isPresent()) {
                Mob storedEntity = Utils.fromUUID((ServerLevel)player.level(), comp.uuid().get());
                if (target != storedEntity) {
                    Utils.setAttackTarget(target, (LivingEntity)storedEntity, true);
                    stack.remove(CrossPlatformStuff.INSTANCE.getComponentMobUuid());
                    return true;
                }
            } else {
                stack.set(CrossPlatformStuff.INSTANCE.getComponentMobUuid(), (Object)new UuidComponent(Optional.of(target.getUUID()), Optional.ofNullable(target.getCustomName())));
                player.sendSystemMessage((Component)Component.translatable((String)"tooltip.stick.add").withStyle(ChatFormatting.GOLD));
                return true;
            }
        }
        return true;
    }
}

