/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.common.items;

import io.github.flemmli97.mobbattle.common.items.LeftClickInteractItem;
import io.github.flemmli97.mobbattle.platform.CrossPlatformStuff;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class MobKill
extends Item
implements LeftClickInteractItem {
    public MobKill(Item.Properties props) {
        super(props);
    }

    public boolean canAttackBlock(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        LivingEntity living;
        if (player instanceof ServerPlayer && (living = CrossPlatformStuff.INSTANCE.tryGetEntity(entity)) instanceof Mob) {
            Mob mob = (Mob)living;
            mob.hurt(entity.damageSources().genericKill(), Float.MAX_VALUE);
            if (mob.isAlive()) {
                mob.kill();
            }
        }
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.translatable((String)"tooltip.kill").withStyle(ChatFormatting.AQUA));
    }
}

