/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.common.items;

import io.github.flemmli97.mobbattle.common.components.UuidListComponent;
import io.github.flemmli97.mobbattle.common.items.LeftClickInteractItem;
import io.github.flemmli97.mobbattle.common.items.MobHighlightItem;
import io.github.flemmli97.mobbattle.common.utils.Utils;
import io.github.flemmli97.mobbattle.platform.CrossPlatformStuff;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class MobGroup
extends Item
implements LeftClickInteractItem,
MobHighlightItem {
    public MobGroup(Item.Properties props) {
        super(props);
    }

    public boolean canAttackBlock(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag b) {
        list.add((Component)Component.translatable((String)"tooltip.group.first").withStyle(ChatFormatting.AQUA));
        list.add((Component)Component.translatable((String)"tooltip.group.second").withStyle(ChatFormatting.AQUA));
        list.add((Component)Component.translatable((String)"tooltip.group.third").withStyle(ChatFormatting.AQUA));
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        LivingEntity living = CrossPlatformStuff.INSTANCE.tryGetEntity((Entity)entity);
        if (living instanceof Mob) {
            Mob mob = (Mob)living;
            if (!player.isShiftKeyDown() && !player.level().isClientSide && stack.has(CrossPlatformStuff.INSTANCE.getComponentMobGroupUuid())) {
                UuidListComponent ids = (UuidListComponent)stack.get(CrossPlatformStuff.INSTANCE.getComponentMobGroupUuid());
                for (UUID id : ids.uuids()) {
                    Mob e = Utils.fromUUID((ServerLevel)player.level(), id);
                    if (mob == e) continue;
                    Utils.setAttackTarget(mob, (LivingEntity)e, true);
                }
                stack.remove(CrossPlatformStuff.INSTANCE.getComponentMobGroupUuid());
                player.setItemInHand(hand, stack);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        UuidListComponent ids;
        ItemStack stack = player.getItemInHand(hand);
        if (!player.level().isClientSide && (ids = (UuidListComponent)stack.get(CrossPlatformStuff.INSTANCE.getComponentMobGroupUuid())) != null && !ids.uuids().isEmpty()) {
            if (!player.isShiftKeyDown() && !ids.uuids().isEmpty()) {
                ids = ids.update(List::removeLast);
                stack.set(CrossPlatformStuff.INSTANCE.getComponentMobGroupUuid(), (Object)ids);
                player.sendSystemMessage((Component)Component.translatable((String)"tooltip.group.remove").withStyle(ChatFormatting.RED));
            } else {
                stack.remove(CrossPlatformStuff.INSTANCE.getComponentMobGroupUuid());
                player.sendSystemMessage((Component)Component.translatable((String)"tooltip.group.reset").withStyle(ChatFormatting.RED));
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        LivingEntity living = CrossPlatformStuff.INSTANCE.tryGetEntity(entity);
        if (living instanceof Mob && !player.level().isClientSide) {
            UuidListComponent ids = (UuidListComponent)stack.getOrDefault(CrossPlatformStuff.INSTANCE.getComponentMobGroupUuid(), (Object)UuidListComponent.EMPTY);
            AtomicBoolean changed = new AtomicBoolean();
            ids = ids.update(list -> {
                if (!list.contains(living.getUUID())) {
                    list.add(living.getUUID());
                    changed.set(true);
                }
            });
            if (changed.get()) {
                stack.set(CrossPlatformStuff.INSTANCE.getComponentMobGroupUuid(), (Object)ids);
                player.sendSystemMessage((Component)Component.translatable((String)"tooltip.group.add").withStyle(ChatFormatting.GOLD));
            }
        }
        return true;
    }
}

