/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.common.items;

import io.github.flemmli97.mobbattle.common.components.AreaPositionComponent;
import io.github.flemmli97.mobbattle.common.entity.ai.EntityAIItemPickup;
import io.github.flemmli97.mobbattle.common.items.LeftClickInteractItem;
import io.github.flemmli97.mobbattle.common.utils.Utils;
import io.github.flemmli97.mobbattle.platform.CrossPlatformStuff;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class MobEquip
extends Item
implements LeftClickInteractItem {
    public MobEquip(Item.Properties props) {
        super(props);
    }

    public boolean canAttackBlock(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag b) {
        list.add((Component)Component.translatable((String)"tooltip.equip.first").withStyle(ChatFormatting.AQUA));
        list.add((Component)Component.translatable((String)"tooltip.equip.second").withStyle(ChatFormatting.AQUA));
        list.add((Component)Component.translatable((String)"tooltip.equip.third").withStyle(ChatFormatting.AQUA));
    }

    public InteractionResult useOn(UseOnContext ctx) {
        ItemStack stack = ctx.getItemInHand();
        if (!ctx.getLevel().isClientSide) {
            AreaPositionComponent comp = (AreaPositionComponent)stack.getOrDefault(CrossPlatformStuff.INSTANCE.getComponentAreaSelection(), (Object)AreaPositionComponent.DEFAULT);
            boolean update = false;
            if (comp.first() == null) {
                comp = comp.withFirst(ctx.getClickedPos());
                update = true;
            } else if (!ctx.getClickedPos().equals((Object)comp.first())) {
                comp.withSecond(ctx.getClickedPos());
                update = true;
            }
            if (update) {
                stack.set(CrossPlatformStuff.INSTANCE.getComponentAreaSelection(), (Object)comp);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide && stack.has(CrossPlatformStuff.INSTANCE.getComponentAreaSelection())) {
            if (player.isShiftKeyDown()) {
                stack.remove(CrossPlatformStuff.INSTANCE.getComponentAreaSelection());
                player.sendSystemMessage((Component)Component.translatable((String)"tooltip.equip.reset").withStyle(ChatFormatting.RED));
            } else {
                AreaPositionComponent comp = (AreaPositionComponent)stack.get(CrossPlatformStuff.INSTANCE.getComponentAreaSelection());
                if (comp.first() != null && comp.second() != null) {
                    AABB bb = Utils.getBoundingBoxPositions(comp.first(), comp.second());
                    List list = player.level().getEntitiesOfClass(Mob.class, bb);
                    for (Mob living : list) {
                        living.addTag("mobbattle:PickUp");
                        CrossPlatformStuff.INSTANCE.goalSelectorFrom(living, false).addGoal(10, (Goal)new EntityAIItemPickup(living));
                    }
                    player.sendSystemMessage((Component)Component.translatable((String)"tooltip.equip.add").withStyle(ChatFormatting.GOLD));
                }
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        LivingEntity living = CrossPlatformStuff.INSTANCE.tryGetEntity(entity);
        if (living instanceof Mob) {
            Mob mob = (Mob)living;
            if (!player.level().isClientSide) {
                mob.addTag("mobbattle:PickUp");
                CrossPlatformStuff.INSTANCE.goalSelectorFrom(mob, false).addGoal(10, (Goal)new EntityAIItemPickup(mob));
                player.sendSystemMessage((Component)Component.translatable((String)"tooltip.equip.add").withStyle(ChatFormatting.GOLD));
            }
        }
        return true;
    }
}

