/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.common.items;

import io.github.flemmli97.mobbattle.common.components.AreaPositionComponent;
import io.github.flemmli97.mobbattle.common.items.LeftClickInteractItem;
import io.github.flemmli97.mobbattle.common.utils.Utils;
import io.github.flemmli97.mobbattle.platform.CrossPlatformStuff;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class MobArmy
extends Item
implements LeftClickInteractItem {
    public MobArmy(Item.Properties props) {
        super(props);
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag b) {
        list.add((Component)Component.translatable((String)"tooltip.army.first").withStyle(ChatFormatting.AQUA));
        list.add((Component)Component.translatable((String)"tooltip.army.second").withStyle(ChatFormatting.AQUA));
        list.add((Component)Component.translatable((String)"tooltip.army.third").withStyle(ChatFormatting.AQUA));
        list.add((Component)Component.translatable((String)"tooltip.army.forth").withStyle(ChatFormatting.AQUA));
    }

    public InteractionResult useOn(UseOnContext ctx) {
        ItemStack stack = ctx.getItemInHand();
        if (!ctx.getLevel().isClientSide) {
            AreaPositionComponent comp = (AreaPositionComponent)stack.getOrDefault(CrossPlatformStuff.INSTANCE.getComponentAreaSelection(), (Object)AreaPositionComponent.DEFAULT);
            boolean update = false;
            if (comp.first() == null) {
                comp = comp.withFirst(ctx.getClickedPos());
                update = true;
            } else if (!ctx.getClickedPos().equals((Object)comp.first())) {
                comp = comp.withSecond(ctx.getClickedPos());
                update = true;
            }
            if (update) {
                stack.set(CrossPlatformStuff.INSTANCE.getComponentAreaSelection(), (Object)comp);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide && stack.has(CrossPlatformStuff.INSTANCE.getComponentAreaSelection())) {
            if (player.isShiftKeyDown()) {
                stack.remove(CrossPlatformStuff.INSTANCE.getComponentAreaSelection());
                player.sendSystemMessage((Component)Component.translatable((String)"tooltip.army.reset").withStyle(ChatFormatting.RED));
            } else {
                AreaPositionComponent comp = (AreaPositionComponent)stack.get(CrossPlatformStuff.INSTANCE.getComponentAreaSelection());
                if (comp.first() != null && comp.second() != null) {
                    AABB bb = Utils.getBoundingBoxPositions(comp.first(), comp.second());
                    List list = player.level().getEntitiesOfClass(Mob.class, bb);
                    String team = stack.has(DataComponents.CUSTOM_NAME) ? stack.getHoverName().getString() : "DEFAULT";
                    for (Mob living : list) {
                        Utils.updateEntity(team, living);
                    }
                    player.sendSystemMessage((Component)Component.translatable((String)"tooltip.army.add.box", (Object[])new Object[]{team}).withStyle(ChatFormatting.GOLD));
                }
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        LivingEntity living = CrossPlatformStuff.INSTANCE.tryGetEntity(entity);
        if (living instanceof Mob) {
            Mob mob = (Mob)living;
            if (!player.level().isClientSide) {
                String team = stack.has(DataComponents.CUSTOM_NAME) ? stack.getHoverName().getString() : "DEFAULT";
                Utils.updateEntity(team, mob);
                player.sendSystemMessage((Component)Component.translatable((String)"tooltip.army.add", (Object[])new Object[]{team}).withStyle(ChatFormatting.GOLD));
            }
        }
        return true;
    }
}

