/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.common.items;

import com.google.common.base.Functions;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import io.github.flemmli97.mobbattle.MobBattle;
import io.github.flemmli97.mobbattle.common.components.SpawnEggOptions;
import io.github.flemmli97.mobbattle.common.items.LeftClickInteractItem;
import io.github.flemmli97.mobbattle.common.utils.Utils;
import io.github.flemmli97.mobbattle.network.S2CSpawnEggScreen;
import io.github.flemmli97.mobbattle.platform.CrossPlatformStuff;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class ItemExtendedSpawnEgg
extends Item
implements LeftClickInteractItem {
    private static final MapCodec<EntityType<?>> ENTITY_TYPE_ID_CODEC = BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("id");

    public ItemExtendedSpawnEgg(Item.Properties props) {
        super(props);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.translatable((String)"tooltip.spawnegg").withStyle(ChatFormatting.AQUA));
        Optional<EntityType<?>> entityType = ItemExtendedSpawnEgg.getType(stack);
        entityType.ifPresent(type -> {
            CustomData data = (CustomData)stack.get(DataComponents.ENTITY_DATA);
            list.add((Component)Component.translatable((String)("tooltip.spawnegg.spawn" + (data.size() > 1 ? ".nbt" : "")), (Object[])new Object[]{type.getDescription()}).withStyle(ChatFormatting.GOLD));
        });
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        LivingEntity living = CrossPlatformStuff.INSTANCE.tryGetEntity(entity);
        if (living instanceof Mob) {
            if (!player.isCreative()) {
                player.sendSystemMessage((Component)Component.translatable((String)"tooltip.spawnegg.creative").withStyle(ChatFormatting.GOLD));
                return true;
            }
            boolean nbt = false;
            CompoundTag tag = new CompoundTag();
            if (player.isShiftKeyDown()) {
                living.save(tag);
                this.removeMobSpecificTags(tag);
                nbt = true;
            } else {
                String name = BuiltInRegistries.ENTITY_TYPE.getKey((Object)living.getType()).toString();
                tag.putString("id", name);
            }
            stack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
            if (!player.level().isClientSide) {
                player.sendSystemMessage((Component)Component.translatable((String)("tooltip.spawnegg.save" + (nbt ? ".nbt" : "")), (Object[])new Object[]{living.getName()}).withStyle(ChatFormatting.GOLD));
            }
            return true;
        }
        return false;
    }

    public InteractionResult useOn(UseOnContext ctx) {
        if (ctx.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = ctx.getItemInHand();
        if (!ctx.getPlayer().mayUseItemAt(ctx.getClickedPos().relative(ctx.getClickedFace()), ctx.getClickedFace(), stack)) {
            return InteractionResult.PASS;
        }
        Optional<EntityType<?>> entityType = ItemExtendedSpawnEgg.getType(stack);
        if (entityType.isEmpty()) {
            return InteractionResult.PASS;
        }
        BlockState state = ctx.getLevel().getBlockState(ctx.getClickedPos());
        BlockEntity blockEntity = ctx.getLevel().getBlockEntity(ctx.getClickedPos());
        if (blockEntity instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawner = (SpawnerBlockEntity)blockEntity;
            CompoundTag nbt = new CompoundTag();
            spawner.getSpawner().save(nbt);
            nbt.remove("SpawnPotentials");
            nbt.remove("SpawnData");
            SpawnData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)new SpawnData(((CustomData)stack.get(DataComponents.ENTITY_DATA)).copyTag(), Optional.empty(), Optional.empty())).resultOrPartial(string -> MobBattle.LOGGER.warn("Invalid SpawnData: {}", string)).ifPresent(t -> nbt.put("SpawnData", t));
            spawner.getSpawner().load(blockEntity.getLevel(), blockEntity.getBlockPos(), nbt);
            spawner.setChanged();
            ctx.getLevel().sendBlockUpdated(ctx.getClickedPos(), state, state, 3);
            return InteractionResult.CONSUME;
        }
        BlockPos blockpos = state.getCollisionShape((BlockGetter)ctx.getLevel(), ctx.getClickedPos()).isEmpty() ? ctx.getClickedPos() : ctx.getClickedPos().relative(ctx.getClickedFace());
        boolean spawned = ItemExtendedSpawnEgg.spawnEntity((ServerLevel)ctx.getLevel(), entityType.get(), stack, (double)blockpos.getX() + 0.5, blockpos.getY(), (double)blockpos.getZ() + 0.5, ctx.getHorizontalDirection());
        if (spawned && !ctx.getPlayer().getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!(player instanceof ServerPlayer)) {
            return InteractionResultHolder.success((Object)stack);
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Optional<EntityType<?>> entityType = ItemExtendedSpawnEgg.getType(stack);
        if (entityType.isEmpty()) {
            return InteractionResultHolder.pass((Object)stack);
        }
        BlockHitResult raytraceresult = ItemExtendedSpawnEgg.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (raytraceresult.getType() == HitResult.Type.BLOCK) {
            boolean spawned;
            BlockPos blockpos = raytraceresult.getBlockPos();
            if (!(world.getBlockState(blockpos).getBlock() instanceof LiquidBlock)) {
                return InteractionResultHolder.pass((Object)stack);
            }
            if (world.mayInteract(player, blockpos) && player.mayUseItemAt(blockpos, raytraceresult.getDirection(), stack) && (spawned = ItemExtendedSpawnEgg.spawnEntity((ServerLevel)world, entityType.get(), stack, (double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.5, (double)blockpos.getZ() + 0.5, player.getDirection())) && !player.getAbilities().instabuild) {
                stack.shrink(1);
            }
        } else {
            CrossPlatformStuff.INSTANCE.sendToClient(new S2CSpawnEggScreen(hand), serverPlayer);
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    public static boolean spawnEntity(ServerLevel level, ItemStack stack, double x, double y, double z, Direction direction) {
        return ItemExtendedSpawnEgg.getType(stack).map(type -> ItemExtendedSpawnEgg.spawnEntity(level, type, stack, x, y, z, direction)).orElse(false);
    }

    private static boolean spawnEntity(ServerLevel level, EntityType<?> type, ItemStack stack, double x, double y, double z, Direction direction) {
        SpawnEggOptions options = (SpawnEggOptions)stack.getOrDefault(CrossPlatformStuff.INSTANCE.getComponentSpawnEggOptions(), (Object)SpawnEggOptions.DEFAULT);
        boolean success = false;
        int sqr = options.amount() > 1 ? (int)Math.ceil(Math.sqrt(options.amount())) : 0;
        BlockPos origin = BlockPos.containing((double)x, (double)y, (double)z);
        for (int i = 0; i < options.amount(); ++i) {
            Entity entity = ItemExtendedSpawnEgg.getEntity((Level)level, type, stack, origin);
            if (!(entity instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            if (options.amount() > 1 && options.spacing() > 0) {
                int dL = i / sqr;
                int dW = i % sqr - sqr / 2;
                Vec3i front = direction.getNormal().multiply(options.spacing());
                Vec3i side = new Vec3i(front.getZ(), front.getY(), -front.getX());
                entity.moveTo(x + (double)(side.getX() * dW) + (double)(front.getX() * dL), y, z + (double)(side.getZ() * dW) + (double)(front.getZ() * dL), Mth.wrapDegrees((float)(direction.toYRot() - 180.0f)), 0.0f);
            } else {
                entity.moveTo(x, y, z, Mth.wrapDegrees((float)(level.random.nextFloat() * 360.0f)), 0.0f);
            }
            mob.yHeadRot = mob.getYRot();
            mob.yBodyRot = mob.getYRot();
            level.addFreshEntity(entity);
            mob.playAmbientSound();
            if (options.team() != null && !options.team().isEmpty()) {
                Utils.updateEntity(options.team(), mob);
            }
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                entity.setCustomName(stack.getHoverName());
            }
            success = true;
        }
        return success;
    }

    public static Entity getEntity(Level level, ItemStack stack) {
        return ItemExtendedSpawnEgg.getType(stack).map(type -> ItemExtendedSpawnEgg.getEntity(level, type, stack, null)).orElse(null);
    }

    private static Entity getEntity(Level level, EntityType<?> type, ItemStack stack, @Nullable BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return type.create(serverLevel, entity -> {
                CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag();
                if (tag.size() > 1) {
                    entity.load(tag);
                }
            }, pos == null ? BlockPos.ZERO : pos, MobSpawnType.SPAWN_EGG, false, false);
        }
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag();
        return EntityType.loadEntityRecursive((CompoundTag)tag, (Level)level, (Function)Functions.identity());
    }

    public static Optional<EntityType<?>> getType(ItemStack stack) {
        return ((CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY)).read(ENTITY_TYPE_ID_CODEC).result();
    }

    private void removeMobSpecificTags(CompoundTag compound) {
        compound.remove("Pos");
        compound.remove("Motion");
        compound.remove("Rotation");
        compound.remove("UUID");
    }

    public boolean isFoil(ItemStack stack) {
        return ItemExtendedSpawnEgg.getType(stack).isPresent();
    }
}

