/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.common.inv;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.mobbattle.MobBattle;
import io.github.flemmli97.mobbattle.common.inv.InventoryArmor;
import io.github.flemmli97.mobbattle.platform.CrossPlatformStuff;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerArmor
extends AbstractContainerMenu {
    private InventoryArmor inv;

    public ContainerArmor(int windowID, Inventory playerInv, RegistryFriendlyByteBuf buf) {
        this(windowID, playerInv, playerInv.player.level().getEntity(buf.readInt()));
    }

    public ContainerArmor(int windowID, Inventory playerInv, Entity e) {
        super(CrossPlatformStuff.INSTANCE.getArmorMenuType(), windowID);
        if (!(e instanceof Mob)) {
            return;
        }
        Mob living = (Mob)e;
        this.inv = new InventoryArmor(living);
        this.inv.startOpen(playerInv.player);
        this.addSlot(new Slot(this, (Container)this.inv, 0, 80, 17){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)MobBattle.of("item/armor_slot_sword"));
            }
        });
        this.addSlot(new Slot(this, (Container)this.inv, 1, 80, 35){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
        this.addSlot(new Slot(this, (Container)this.inv, 2, 44, 17){

            public int getMaxStackSize() {
                return 1;
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_HELMET);
            }
        });
        this.addSlot(new Slot((Container)this.inv, 3, 44, 35){

            public int getMaxStackSize() {
                return 1;
            }

            public boolean mayPlace(ItemStack stack) {
                return ContainerArmor.this.inv.canPlaceItem(this.index, stack);
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE);
            }
        });
        this.addSlot(new Slot((Container)this.inv, 4, 116, 17){

            public int getMaxStackSize() {
                return 1;
            }

            public boolean mayPlace(ItemStack stack) {
                return ContainerArmor.this.inv.canPlaceItem(this.index, stack);
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS);
            }
        });
        this.addSlot(new Slot((Container)this.inv, 5, 116, 35){

            public int getMaxStackSize() {
                return 1;
            }

            public boolean mayPlace(ItemStack stack) {
                return ContainerArmor.this.inv.canPlaceItem(this.index, stack);
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS);
            }
        });
        for (int column = 0; column < 3; ++column) {
            for (int row = 0; row < 9; ++row) {
                this.addSlot(new Slot((Container)playerInv, row + column * 9 + 9, 8 + row * 18, 66 + column * 18));
            }
        }
        for (int rowHotBar = 0; rowHotBar < 9; ++rowHotBar) {
            this.addSlot(new Slot((Container)playerInv, rowHotBar, 8 + rowHotBar * 18, 124));
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 6 ? !this.moveItemStackTo(itemstack1, 6, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, 6, true)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }
}

