/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.common.entity.ai;

import io.github.flemmli97.mobbattle.common.utils.ActiveTargetMobbattle;
import io.github.flemmli97.mobbattle.common.utils.Utils;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;

public class EntityAITeamTarget
extends NearestAttackableTargetGoal<LivingEntity> {
    public EntityAITeamTarget(Mob mob, boolean checkSight, boolean onlyNearby) {
        super(mob, LivingEntity.class, 10, checkSight, onlyNearby, EntityAITeamTarget.targetPred(mob));
        this.targetConditions.ignoreLineOfSight();
    }

    public static Predicate<LivingEntity> targetPred(Mob mob) {
        return living -> {
            if (living instanceof Player) {
                Player player = (Player)living;
                if (player.getAbilities().invulnerable) {
                    return false;
                }
            }
            return Utils.canTargetEntity((Entity)living, (Entity)mob);
        };
    }

    public boolean canUse() {
        Mob mob = this.mob;
        if (mob instanceof ActiveTargetMobbattle) {
            ActiveTargetMobbattle active = (ActiveTargetMobbattle)mob;
            active.mobbattle$setTargeting(true);
        }
        boolean res = super.canUse();
        Mob mob2 = this.mob;
        if (mob2 instanceof ActiveTargetMobbattle) {
            ActiveTargetMobbattle active = (ActiveTargetMobbattle)mob2;
            active.mobbattle$setTargeting(false);
        }
        return res;
    }

    public void start() {
        Utils.setAttackTarget(this.mob, this.target, false);
        super.start();
    }
}

