/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.common.entity.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class EntityAIItemPickup
extends Goal {
    private final Mob entity;
    private List<ItemEntity> nearby;

    public EntityAIItemPickup(Mob creature) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        this.entity = creature;
    }

    public boolean canUse() {
        if (this.entity.getTarget() == null) {
            List list = this.entity.level().getEntitiesOfClass(ItemEntity.class, this.entity.getBoundingBox().inflate(8.0));
            if (list.isEmpty()) {
                return false;
            }
            this.nearby = list;
            return true;
        }
        return false;
    }

    public void start() {
        ItemEntity item = this.nearby.get(this.entity.getRandom().nextInt(this.nearby.size()));
        this.entity.getNavigation().moveTo(item.getX(), item.getY(), item.getZ(), 1.0);
    }

    public void tick() {
        for (ItemEntity entityitem : this.entity.level().getEntitiesOfClass(ItemEntity.class, this.entity.getBoundingBox().inflate(1.0, 0.0, 1.0))) {
            if (entityitem.getItem().isEmpty() || entityitem.hasPickUpDelay()) continue;
            this.updateEquipmentIfNeeded(entityitem);
        }
    }

    private boolean isItemBetter(ItemStack stack, ItemStack currentEquipped) {
        double d2;
        double d1;
        DamageSource damageSource1;
        Mob target;
        Object object = target = this.entity.getTarget() != null ? this.entity.getTarget() : this.entity;
        if (stack.getItem() instanceof ArmorItem) {
            if (!(currentEquipped.getItem() instanceof ArmorItem) || EnchantmentHelper.has((ItemStack)currentEquipped, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) {
                return true;
            }
            Item item = currentEquipped.getItem();
            if (item instanceof ArmorItem) {
                ArmorItem itemarmor1 = (ArmorItem)item;
                ArmorItem itemarmor = (ArmorItem)stack.getItem();
                if (itemarmor.getDefense() == itemarmor1.getDefense()) {
                    return stack.getDamageValue() > currentEquipped.getDamageValue() || stack.getComponentsPatch().isEmpty() && !currentEquipped.getComponentsPatch().isEmpty();
                }
                return itemarmor.getDefense() > itemarmor1.getDefense();
            }
        }
        if (currentEquipped.isEmpty()) {
            return true;
        }
        DamageSource damageSource2 = damageSource1 = this.entity.damageSources().mobAttack((LivingEntity)this.entity);
        if (stack.getItem() instanceof BowItem) {
            damageSource1 = this.entity.damageSources().arrow((AbstractArrow)EntityType.ARROW.create(this.entity.level()), (Entity)this.entity);
        }
        if (currentEquipped.getItem() instanceof BowItem) {
            damageSource2 = this.entity.damageSources().arrow((AbstractArrow)EntityType.ARROW.create(this.entity.level()), (Entity)this.entity);
        }
        return (d1 = (double)EnchantmentHelper.modifyDamage((ServerLevel)((ServerLevel)this.entity.level()), (ItemStack)stack, (Entity)target, (DamageSource)damageSource1, (float)1.0f)) > (d2 = (double)EnchantmentHelper.modifyDamage((ServerLevel)((ServerLevel)this.entity.level()), (ItemStack)currentEquipped, (Entity)target, (DamageSource)damageSource2, (float)1.0f));
    }

    protected void updateEquipmentIfNeeded(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.getItem().copy();
        itemstack.setCount(1);
        EquipmentSlot EquipmentSlotType = this.entity.getEquipmentSlotForItem(itemstack);
        ItemStack itemstack1 = this.entity.getItemBySlot(EquipmentSlotType);
        if (this.isItemBetter(itemstack, itemstack1)) {
            this.entity.spawnAtLocation(itemstack1, 0.0f);
            this.entity.setItemSlot(EquipmentSlotType, itemstack);
            this.entity.setDropChance(EquipmentSlotType, 0.0f);
            this.entity.setPersistenceRequired();
            this.entity.level().playSound(null, this.entity.getX(), this.entity.getY(), this.entity.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (this.entity.getRandom().nextFloat() - this.entity.getRandom().nextFloat()) * 1.4f + 2.0f);
            itemEntity.getItem().shrink(1);
        }
    }
}

