/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.common.entity.ai;

import io.github.flemmli97.mobbattle.MobBattle;
import io.github.flemmli97.mobbattle.common.entity.ai.EntityAITeamTarget;
import io.github.flemmli97.mobbattle.common.utils.ActiveTargetMobbattle;
import java.util.EnumSet;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;

public class EntityAIHurt
extends TargetGoal {
    protected final TargetingConditions targetConditions;
    private int timestamp;

    public EntityAIHurt(Mob mob) {
        super(mob, true);
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        this.targetConditions = TargetingConditions.forCombat().ignoreLineOfSight().ignoreInvisibilityTesting().selector(EntityAITeamTarget.targetPred(mob));
    }

    public boolean canUse() {
        int i = this.mob.getLastHurtByMobTimestamp();
        LivingEntity livingEntity = this.mob.getLastHurtByMob();
        if (i == this.timestamp || livingEntity == null) {
            return false;
        }
        Mob mob = this.mob;
        if (mob instanceof ActiveTargetMobbattle) {
            ActiveTargetMobbattle active = (ActiveTargetMobbattle)mob;
            active.mobbattle$setTargeting(true);
        }
        boolean res = this.canAttack(livingEntity, this.targetConditions);
        Mob mob2 = this.mob;
        if (mob2 instanceof ActiveTargetMobbattle) {
            ActiveTargetMobbattle active = (ActiveTargetMobbattle)mob2;
            active.mobbattle$setTargeting(false);
        }
        return res;
    }

    public boolean canContinueToUse() {
        int i = this.mob.getLastHurtByMobTimestamp();
        LivingEntity livingEntity = this.mob.getLastHurtByMob();
        if (livingEntity == null) {
            return false;
        }
        if (this.mob.getLastHurtMobTimestamp() + 40 < i && (this.mob.getTarget() == null || this.mob.getTarget() != livingEntity && !livingEntity.getType().is(MobBattle.HURT_IGNORED))) {
            return false;
        }
        return super.canContinueToUse();
    }

    public void start() {
        this.mob.setTarget(this.mob.getLastHurtByMob());
        this.targetMob = this.mob.getTarget();
        this.timestamp = this.mob.getLastHurtByMobTimestamp();
        this.unseenMemoryTicks = 300;
        super.start();
    }

    public void stop() {
        super.stop();
        this.timestamp = -1;
    }
}

