/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.common.components;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record UuidListComponent(List<UUID> uuids) {
    public static final UuidListComponent EMPTY = new UuidListComponent(List.of());
    public static final Codec<UuidListComponent> CODEC = UUIDUtil.CODEC.listOf().fieldOf("uuids").xmap(UuidListComponent::new, UuidListComponent::uuids).codec();
    public static final StreamCodec<ByteBuf, UuidListComponent> STREAM_CODEC = UUIDUtil.STREAM_CODEC.apply(ByteBufCodecs.list()).map(UuidListComponent::new, UuidListComponent::uuids);

    public UuidListComponent(List<UUID> uuids) {
        this.uuids = ImmutableList.copyOf(uuids);
    }

    public UuidListComponent update(Consumer<List<UUID>> cons) {
        ArrayList<UUID> list = new ArrayList<UUID>(this.uuids);
        cons.accept(list);
        return new UuidListComponent(list);
    }
}

