/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.common.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;

public record UuidComponent(Optional<UUID> uuid, Optional<Component> name) {
    public static final UuidComponent EMPTY = new UuidComponent(Optional.empty(), Optional.empty());
    public static final Codec<UuidComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.optionalFieldOf("uuids").forGetter(UuidComponent::uuid), (App)ComponentSerialization.FLAT_CODEC.optionalFieldOf("name").forGetter(UuidComponent::name)).apply((Applicative)instance, UuidComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, UuidComponent> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, UuidComponent>(){

        public UuidComponent decode(RegistryFriendlyByteBuf buf) {
            return new UuidComponent(buf.readBoolean() ? Optional.of(FriendlyByteBuf.readUUID((ByteBuf)buf)) : Optional.empty(), buf.readBoolean() ? Optional.of((Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf)) : Optional.empty());
        }

        public void encode(RegistryFriendlyByteBuf buf, UuidComponent component) {
            buf.writeBoolean(component.uuid().isPresent());
            component.uuid().ifPresent(id -> FriendlyByteBuf.writeUUID((ByteBuf)buf, (UUID)id));
            buf.writeBoolean(component.name().isPresent());
            component.name().ifPresent(comp -> ComponentSerialization.STREAM_CODEC.encode((Object)buf, comp));
        }
    };
}

