/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.common.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public record SpawnEggOptions(@Nullable String team, int amount, int spacing) {
    public static final SpawnEggOptions DEFAULT = new SpawnEggOptions(null, 1, 0);
    public static final Codec<SpawnEggOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("team").forGetter(d -> Optional.ofNullable(d.team())), (App)ExtraCodecs.POSITIVE_INT.fieldOf("amount").forGetter(SpawnEggOptions::amount), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("spacing").forGetter(SpawnEggOptions::spacing)).apply((Applicative)instance, (team, amount, spacing) -> new SpawnEggOptions(team.orElse(null), (int)amount, (int)spacing)));
    public static final StreamCodec<FriendlyByteBuf, SpawnEggOptions> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, SpawnEggOptions>(){

        public SpawnEggOptions decode(FriendlyByteBuf buf) {
            return new SpawnEggOptions((String)buf.readNullable(FriendlyByteBuf::readUtf), buf.readInt(), buf.readInt());
        }

        public void encode(FriendlyByteBuf buf, SpawnEggOptions component) {
            buf.writeNullable((Object)component.team(), FriendlyByteBuf::writeUtf);
            buf.writeInt(component.amount());
            buf.writeInt(component.spacing());
        }
    };

    public SpawnEggOptions(@Nullable String team, int amount, int spacing) {
        this.team = team;
        this.amount = Mth.clamp((int)amount, (int)0, (int)100);
        this.spacing = Mth.clamp((int)spacing, (int)0, (int)99);
    }
}

