/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.common;

import io.github.flemmli97.mobbattle.common.Config;
import io.github.flemmli97.mobbattle.common.entity.ai.EntityAIItemPickup;
import io.github.flemmli97.mobbattle.common.utils.Utils;
import io.github.flemmli97.mobbattle.mixin.MobAccessor;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class EventCalls {
    public static void handleJoinLevel(Entity entity) {
        if (!entity.level().isClientSide && entity instanceof Mob) {
            OwnableEntity ownable;
            LivingEntity owner;
            if (entity instanceof TraceableEntity) {
                TraceableEntity traceable = (TraceableEntity)entity;
                Entity owner2 = traceable.getOwner();
                if (owner2 != null && owner2.getTeam() != null) {
                    Utils.addEntityToTeam(entity, owner2.getTeam().getName());
                }
            } else if (entity instanceof OwnableEntity && (owner = (ownable = (OwnableEntity)entity).getOwner()) != null && owner.getTeam() != null) {
                Utils.addEntityToTeam(entity, owner.getTeam().getName());
            }
            if (entity.getTeam() != null) {
                Utils.updateEntity(entity.getTeam().getName(), (Mob)entity);
            }
            if (entity.getTags().contains("mobbattle:PickUp")) {
                ((MobAccessor)entity).getGoalSelector().addGoal(10, (Goal)new EntityAIItemPickup((Mob)entity));
            }
        }
    }

    public static boolean handleFriendlyFire(LivingEntity entity, DamageSource source) {
        Entity entity2 = source.getEntity();
        if (entity2 instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity2;
            return !Utils.isOnSameTeam((Entity)entity, (Entity)attacker) || entity.getTeam().isAllowFriendlyFire();
        }
        return true;
    }

    public static void tick(Entity entity) {
        Mob mob;
        if (entity instanceof Mob && (mob = (Mob)entity).getTeam() != null) {
            if (Config.showTeamParticleTypes && mob.level().isClientSide) {
                DustParticleOptions color = Utils.teamColor.get(mob.getTeam().getColor());
                if (color != null) {
                    mob.level().addParticle((ParticleOptions)color, mob.getX(), mob.getY() + (double)mob.getBbHeight() + 0.5, mob.getZ(), 0.0, 0.0, 0.0);
                }
            } else if (Config.autoAddAI && !mob.getTags().contains("mobbattle:AddedAI")) {
                Utils.updateEntity(mob.getTeam().getName(), mob);
            }
        }
    }
}

