/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.mobbattle.client.gui.GuiEffect;
import io.github.flemmli97.mobbattle.client.gui.SpawnEggScreen;
import io.github.flemmli97.mobbattle.common.components.UuidComponent;
import io.github.flemmli97.mobbattle.common.components.UuidListComponent;
import io.github.flemmli97.mobbattle.common.items.MobHighlightItem;
import io.github.flemmli97.mobbattle.common.utils.Utils;
import io.github.flemmli97.mobbattle.platform.CrossPlatformStuff;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class ClientHandler {
    public static void openEffectGui() {
        Minecraft.getInstance().setScreen((Screen)new GuiEffect());
    }

    public static void renderBlockOutline(PoseStack stack, MultiBufferSource.BufferSource buffer, BlockPos pos, BlockPos pos2) {
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        stack.pushPose();
        stack.mulPose(camera.rotation().conjugate(new Quaternionf()));
        AABB aabb = Utils.getBoundingBoxPositions(pos, pos2).deflate(0.05);
        Vec3 vec = camera.getPosition();
        stack.translate(-vec.x, -vec.y, -vec.z);
        LevelRenderer.renderLineBox((PoseStack)stack, (VertexConsumer)buffer.getBuffer(RenderType.lines()), (AABB)aabb, (float)1.0f, (float)0.5f, (float)0.5f, (float)1.0f);
        buffer.endBatch((RenderType)RenderType.LINES);
        stack.popPose();
    }

    public static void openSpawneggGui(InteractionHand hand) {
        Minecraft.getInstance().setScreen((Screen)new SpawnEggScreen(hand));
    }

    public static boolean handleEntityHighlight(Entity entity) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        if (ClientHandler.isHighlighted(entity, player.getMainHandItem())) {
            return true;
        }
        return ClientHandler.isHighlighted(entity, player.getOffhandItem());
    }

    private static boolean isHighlighted(Entity entity, ItemStack stack) {
        boolean highlight = false;
        if (stack.getItem() instanceof MobHighlightItem) {
            HitResult res = Minecraft.getInstance().hitResult;
            if (res != null && res.getType() == HitResult.Type.ENTITY && entity == CrossPlatformStuff.INSTANCE.tryGetEntity(((EntityHitResult)res).getEntity())) {
                return true;
            }
            UuidComponent id = (UuidComponent)stack.get(CrossPlatformStuff.INSTANCE.getComponentMobUuid());
            if (id != null && id.uuid().isPresent() && entity.getUUID().equals(id.uuid().get())) {
                return true;
            }
            UuidListComponent list = (UuidListComponent)stack.get(CrossPlatformStuff.INSTANCE.getComponentMobGroupUuid());
            if (list != null && list.uuids().stream().anyMatch(uuid -> entity.getUUID().equals(uuid))) {
                return true;
            }
        }
        return highlight;
    }
}

