/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobBattle {
    public static final String MODID = "mobbattle";
    public static boolean tenshiLib;
    public static final Logger LOGGER;
    public static TagKey<EntityType<?>> IGNORED;
    public static TagKey<EntityType<?>> HURT_IGNORED;
    public static Supplier<CreativeModeTab> customTab;

    public static <T> T getPlatformInstance(Class<T> abstractClss, String fabricImpl, String neoForgeImpl) {
        Class<?> clss = null;
        try {
            clss = Class.forName(neoForgeImpl);
        }
        catch (ClassNotFoundException e) {
            try {
                clss = Class.forName(fabricImpl);
            }
            catch (ClassNotFoundException ex) {
                LOGGER.fatal("No Implementation of {} found with given paths {} and {}", abstractClss, (Object)neoForgeImpl, (Object)fabricImpl);
            }
        }
        if (clss != null && abstractClss.isAssignableFrom(clss)) {
            try {
                Constructor<?> constructor = clss.getDeclaredConstructor(new Class[0]);
                return (T)constructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                LOGGER.fatal("Implementation of {} needs to provide an no arg constructor", clss);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                LOGGER.error((Object)e);
            }
        }
        throw new IllegalStateException("Couldn't create an instance of " + String.valueOf(abstractClss));
    }

    public static ResourceLocation of(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
        IGNORED = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)MobBattle.of("ignored_mobs"));
        HURT_IGNORED = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)MobBattle.of("hurt_ignored_mobs"));
    }
}

