/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trollcave;

import com.mojang.serialization.Codec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.HugeBrownMushroomFeature;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import twilightforest.util.features.FeatureLogic;

@ParametersAreNonnullByDefault
public class TrollHugeBrownMushroomFeature
extends HugeBrownMushroomFeature {
    public TrollHugeBrownMushroomFeature(Codec<HugeMushroomFeatureConfiguration> config) {
        super(config);
    }

    protected void makeCap(LevelAccessor levelAccessor, RandomSource random, BlockPos pos, int height, BlockPos.MutableBlockPos mutableBlockPos, HugeMushroomFeatureConfiguration featureConfiguration) {
        int foliageRadius = featureConfiguration.foliageRadius;
        for (int x = -foliageRadius; x <= foliageRadius; ++x) {
            for (int z = -foliageRadius; z <= foliageRadius; ++z) {
                if (FeatureLogic.isCornerInSquare(x, z, foliageRadius)) continue;
                mutableBlockPos.setWithOffset((Vec3i)pos, x, height, z);
                if (levelAccessor.getBlockState((BlockPos)mutableBlockPos).is(BlockTags.FEATURES_CANNOT_REPLACE)) continue;
                BlockState blockState = featureConfiguration.capProvider.getState(random, pos);
                if (FeatureLogic.hasHorizontalMushroomProperties(blockState)) {
                    blockState = FeatureLogic.getHorizontalMushroomBlockState(blockState, x, z, foliageRadius);
                }
                this.setBlock((LevelWriter)levelAccessor, (BlockPos)mutableBlockPos, blockState);
            }
        }
    }
}

