/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.mojang.serialization.Codec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import twilightforest.world.components.feature.trees.CanopyMushroomFeature;

@ParametersAreNonnullByDefault
public class RedCanopyMushroomFeature
extends CanopyMushroomFeature {
    private final int enumHead;

    public RedCanopyMushroomFeature(Codec<HugeMushroomFeatureConfiguration> featureConfigurationCodec, int enumHead) {
        super(featureConfigurationCodec);
        this.enumHead = enumHead;
    }

    public boolean place(FeaturePlaceContext<HugeMushroomFeatureConfiguration> context) {
        return super.place(context);
    }

    @Override
    protected int getTreeHeight(RandomSource random) {
        return super.getTreeHeight(random) + 3;
    }

    @Override
    protected int getBranches(RandomSource random) {
        return 3;
    }

    @Override
    protected double getLength(RandomSource random) {
        return 10 + random.nextInt(2);
    }

    @Override
    protected void makeCap(LevelAccessor levelAccessor, RandomSource random, BlockPos pos, int height, BlockPos.MutableBlockPos mutableBlockPos, HugeMushroomFeatureConfiguration featureConfiguration) {
        if (this.enumHead == 0) {
            this.makeVanillaCap(levelAccessor, random, pos, height, mutableBlockPos, featureConfiguration);
        } else if (this.enumHead == 1) {
            this.makeSmoothCap(levelAccessor, random, pos, height, mutableBlockPos, featureConfiguration);
        } else if (this.enumHead == 2) {
            this.makeSpheroidCap(levelAccessor, random, pos, height, mutableBlockPos, featureConfiguration);
        } else {
            super.makeCap(levelAccessor, random, pos, height, mutableBlockPos, featureConfiguration);
        }
    }

    protected void makeVanillaCap(LevelAccessor levelAccessor, RandomSource random, BlockPos pos, int height, BlockPos.MutableBlockPos mutableBlockPos, HugeMushroomFeatureConfiguration featureConfiguration) {
        for (int y = height - 3; y <= height; ++y) {
            int j = y < height ? featureConfiguration.foliageRadius : featureConfiguration.foliageRadius - 1;
            int k = featureConfiguration.foliageRadius - 2;
            for (int x = -j; x <= j; ++x) {
                for (int z = -j; z <= j; ++z) {
                    boolean zMinMax;
                    boolean xIsMin = x == -j;
                    boolean xIsMax = x == j;
                    boolean zIsMin = z == -j;
                    boolean zIsMax = z == j;
                    boolean xMinMax = xIsMin || xIsMax;
                    boolean bl = zMinMax = zIsMin || zIsMax;
                    if (y < height && xMinMax == zMinMax) continue;
                    mutableBlockPos.setWithOffset((Vec3i)pos, x, y, z);
                    if (levelAccessor.getBlockState((BlockPos)mutableBlockPos).isSolidRender((BlockGetter)levelAccessor, (BlockPos)mutableBlockPos)) continue;
                    BlockState blockstate = featureConfiguration.capProvider.getState(random, pos);
                    if (blockstate.hasProperty((Property)HugeMushroomBlock.WEST) && blockstate.hasProperty((Property)HugeMushroomBlock.EAST) && blockstate.hasProperty((Property)HugeMushroomBlock.NORTH) && blockstate.hasProperty((Property)HugeMushroomBlock.SOUTH) && blockstate.hasProperty((Property)HugeMushroomBlock.UP)) {
                        blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockstate.setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.valueOf(y >= height - 1))).setValue((Property)HugeMushroomBlock.WEST, (Comparable)Boolean.valueOf(x < -k))).setValue((Property)HugeMushroomBlock.EAST, (Comparable)Boolean.valueOf(x > k))).setValue((Property)HugeMushroomBlock.NORTH, (Comparable)Boolean.valueOf(z < -k))).setValue((Property)HugeMushroomBlock.SOUTH, (Comparable)Boolean.valueOf(z > k));
                    }
                    this.setBlock((LevelWriter)levelAccessor, (BlockPos)mutableBlockPos, blockstate);
                }
            }
        }
    }

    protected void makeSmoothCap(LevelAccessor levelAccessor, RandomSource random, BlockPos pos, int height, BlockPos.MutableBlockPos mutableBlockPos, HugeMushroomFeatureConfiguration featureConfiguration) {
        for (int y = height - 2; y <= height + 1; ++y) {
            int j = featureConfiguration.foliageRadius - Math.max(0, y - (height - 1)) + 1;
            for (int x = -j; x <= j; ++x) {
                for (int z = -j; z <= j; ++z) {
                    if (!RedCanopyMushroomFeature.isInsideSmoothShape(height, j, x, y, z)) continue;
                    mutableBlockPos.setWithOffset((Vec3i)pos, x, y, z);
                    if (levelAccessor.getBlockState((BlockPos)mutableBlockPos).isSolidRender((BlockGetter)levelAccessor, (BlockPos)mutableBlockPos)) continue;
                    BlockState blockstate = featureConfiguration.capProvider.getState(random, pos);
                    if (blockstate.hasProperty((Property)HugeMushroomBlock.WEST) && blockstate.hasProperty((Property)HugeMushroomBlock.EAST) && blockstate.hasProperty((Property)HugeMushroomBlock.NORTH) && blockstate.hasProperty((Property)HugeMushroomBlock.SOUTH) && blockstate.hasProperty((Property)HugeMushroomBlock.UP)) {
                        blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockstate.setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.valueOf(!RedCanopyMushroomFeature.isInsideSmoothShape(height, j - (y > height - 2 ? 1 : 0), x, y + 1, z)))).setValue((Property)HugeMushroomBlock.WEST, (Comparable)Boolean.valueOf(!RedCanopyMushroomFeature.isInsideSmoothShape(height, j, x - 1, y, z) && x < 0))).setValue((Property)HugeMushroomBlock.EAST, (Comparable)Boolean.valueOf(!RedCanopyMushroomFeature.isInsideSmoothShape(height, j, x + 1, y, z) && x > 0))).setValue((Property)HugeMushroomBlock.NORTH, (Comparable)Boolean.valueOf(!RedCanopyMushroomFeature.isInsideSmoothShape(height, j, x, y, z - 1) && z < 0))).setValue((Property)HugeMushroomBlock.SOUTH, (Comparable)Boolean.valueOf(!RedCanopyMushroomFeature.isInsideSmoothShape(height, j, x, y, z + 1) && z > 0));
                    }
                    this.setBlock((LevelWriter)levelAccessor, (BlockPos)mutableBlockPos, blockstate);
                }
            }
        }
    }

    private static boolean isInsideSmoothShape(int height, int j, int x, int y, int z) {
        boolean zMinMax;
        int i = y - (height - 2);
        if (i == 4 || Math.abs(x) > j || Math.abs(z) > j) {
            return false;
        }
        if (i >= 2) {
            return true;
        }
        boolean xIsMin = x == -j;
        boolean xIsMax = x == j;
        boolean zIsMin = z == -j;
        boolean zIsMax = z == j;
        boolean xMinMax = xIsMin || xIsMax;
        boolean bl = zMinMax = zIsMin || zIsMax;
        if (i == 1 && (xMinMax && Math.abs(z) == j - 1 || zMinMax && Math.abs(x) == j - 1)) {
            return false;
        }
        return xMinMax != zMinMax || Math.abs(x) == Math.abs(z) && Math.abs(x) == j - 1;
    }

    protected void makeSpheroidCap(LevelAccessor levelAccessor, RandomSource random, BlockPos pos, int height, BlockPos.MutableBlockPos mutableBlockPos, HugeMushroomFeatureConfiguration featureConfiguration) {
        for (int y = height - 2; y <= height; ++y) {
            int j = y == height - 1 ? featureConfiguration.foliageRadius + 2 : featureConfiguration.foliageRadius + 1;
            for (int x = -j; x <= j; ++x) {
                for (int z = -j; z <= j; ++z) {
                    double maxDistance;
                    double distance = Math.sqrt(x * x + z * z);
                    if (!(distance <= (maxDistance = (double)j + 0.1))) continue;
                    mutableBlockPos.setWithOffset((Vec3i)pos, x, y, z);
                    if (levelAccessor.getBlockState((BlockPos)mutableBlockPos).isSolidRender((BlockGetter)levelAccessor, (BlockPos)mutableBlockPos)) continue;
                    BlockState blockstate = featureConfiguration.capProvider.getState(random, pos);
                    if (blockstate.hasProperty((Property)HugeMushroomBlock.WEST) && blockstate.hasProperty((Property)HugeMushroomBlock.EAST) && blockstate.hasProperty((Property)HugeMushroomBlock.NORTH) && blockstate.hasProperty((Property)HugeMushroomBlock.SOUTH) && blockstate.hasProperty((Property)HugeMushroomBlock.UP)) {
                        blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockstate.setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.valueOf(y > height - 2 && (y == height || distance > maxDistance - 1.0)))).setValue((Property)HugeMushroomBlock.WEST, (Comparable)Boolean.valueOf(Math.sqrt((x - 1) * (x - 1) + z * z) > maxDistance))).setValue((Property)HugeMushroomBlock.EAST, (Comparable)Boolean.valueOf(Math.sqrt((x + 1) * (x + 1) + z * z) > maxDistance))).setValue((Property)HugeMushroomBlock.NORTH, (Comparable)Boolean.valueOf(Math.sqrt(x * x + (z - 1) * (z - 1)) > maxDistance))).setValue((Property)HugeMushroomBlock.SOUTH, (Comparable)Boolean.valueOf(Math.sqrt(x * x + (z + 1) * (z + 1)) > maxDistance));
                    }
                    this.setBlock((LevelWriter)levelAccessor, (BlockPos)mutableBlockPos, blockstate);
                }
            }
        }
    }
}

