/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WebFeature
extends Feature<NoneFeatureConfiguration> {
    public WebFeature(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    private static boolean isValidMaterial(BlockState state) {
        return state.is(BlockTags.LOGS) || state.is(BlockTags.LEAVES);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> config) {
        WorldGenLevel world = config.level();
        BlockPos pos = config.origin().above(config.random().nextInt(world.getMaxBuildHeight() - config.origin().getY()));
        while (pos.getY() > config.origin().getY()) {
            pos = pos.below();
            BlockState state = world.getBlockState(pos);
            if (!world.isEmptyBlock(pos.below()) || !WebFeature.isValidMaterial(state)) continue;
            world.setBlock(state.is(BlockTags.LEAVES) && config.random().nextBoolean() ? pos : pos.below(), Blocks.COBWEB.defaultBlockState(), 18);
            return true;
        }
        return false;
    }
}

