/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import twilightforest.util.landmarks.LegacyLandmarkPlacements;
import twilightforest.world.components.structures.placements.LandmarkGridPlacement;

public final class WorldUtil {
    private WorldUtil() {
    }

    public static long getOverworldSeed() {
        return Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer()).getWorldData().worldGenOptions().seed();
    }

    public static RegistryAccess getRegistryAccess() {
        return Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer()).registryAccess();
    }

    public static Difficulty getDifficulty() {
        return Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer()).getWorldData().getDifficulty();
    }

    public static Iterable<BlockPos> getAllAround(BlockPos center, int range) {
        return BlockPos.betweenClosed((BlockPos)center.offset(-range, -range, -range), (BlockPos)center.offset(range, range, range));
    }

    public static Iterable<BlockPos> getAllInBB(AABB bb) {
        return BlockPos.betweenClosed((int)((int)bb.minX), (int)((int)bb.minY), (int)((int)bb.minZ), (int)((int)bb.maxX), (int)((int)bb.maxY), (int)((int)bb.maxZ));
    }

    public static BlockPos randomOffset(RandomSource random, BlockPos pos, int range) {
        return WorldUtil.randomOffset(random, pos, range, range, range);
    }

    public static BlockPos randomOffset(RandomSource random, BlockPos pos, int rx, int ry, int rz) {
        int dx = random.nextInt(rx * 2 + 1) - rx;
        int dy = random.nextInt(ry * 2 + 1) - ry;
        int dz = random.nextInt(rz * 2 + 1) - rz;
        return pos.offset(dx, dy, dz);
    }

    public static <T> T getRandomElementWithWeights(List<Pair<T, Float>> list, RandomSource rng) {
        float totalWeight = (float)list.stream().mapToDouble(Pair::getSecond).sum();
        float randomValue = rng.nextFloat() * totalWeight;
        for (Pair<T, Float> pair : list) {
            if (!((randomValue -= ((Float)pair.getSecond()).floatValue()) < 0.0f)) continue;
            return (T)pair.getFirst();
        }
        return (T)((Pair)Util.getRandom(list, (RandomSource)rng)).getFirst();
    }

    public static int getGeneratorSeaLevel(LevelAccessor level) {
        int n;
        ChunkSource chunkSource = level.getChunkSource();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache chunkSource2 = (ServerChunkCache)chunkSource;
            n = chunkSource2.chunkMap.generator().getSeaLevel();
        } else {
            n = 0;
        }
        return n;
    }

    public static Optional<Pair<BlockPos, Holder<Structure>>> findNearestMapLandmark(ServerLevel level, HolderSet<Structure> targetStructures, BlockPos pos, int chunkSearchRadius, boolean skipKnownStructures) {
        ChunkGeneratorStructureState state = level.getChunkSource().getGeneratorState();
        Object2ObjectArrayMap seekStructures = new Object2ObjectArrayMap();
        for (Holder holder : targetStructures) {
            for (StructurePlacement structureplacement : state.getPlacementsForStructure(holder)) {
                if (!(structureplacement instanceof LandmarkGridPlacement)) continue;
                LandmarkGridPlacement landmarkPlacement = (LandmarkGridPlacement)structureplacement;
                seekStructures.computeIfAbsent(landmarkPlacement, v -> new ObjectArraySet()).add(holder);
            }
        }
        if (seekStructures.isEmpty()) {
            return Optional.empty();
        }
        double distance = Double.MAX_VALUE;
        Pair nearest = null;
        StructureManager structureManager = level.structureManager();
        for (BlockPos landmarkCenterPosition : LegacyLandmarkPlacements.landmarkCenterScanner(pos, chunkSearchRadius)) {
            block3: for (Map.Entry landmarkPlacement : seekStructures.entrySet()) {
                if (!((LandmarkGridPlacement)((Object)landmarkPlacement.getKey())).isStructureChunk(state, landmarkCenterPosition.getX() >> 4, landmarkCenterPosition.getZ() >> 4)) continue;
                for (Holder targetStructure : targetStructures) {
                    if (!((Set)landmarkPlacement.getValue()).contains(targetStructure)) continue;
                    Holder biome = level.getBiome(landmarkCenterPosition);
                    if (!((Structure)targetStructure.value()).biomes().contains(biome)) continue;
                    if (skipKnownStructures && structureManager.checkStructurePresence(new ChunkPos(landmarkCenterPosition), (Structure)targetStructure.value(), (StructurePlacement)landmarkPlacement.getKey(), true) == StructureCheckResult.START_PRESENT) continue block3;
                    double newDistance = landmarkCenterPosition.distToLowCornerSqr((double)pos.getX(), 0.0, (double)pos.getZ());
                    if (!(newDistance < distance)) continue;
                    nearest = new Pair((Object)landmarkCenterPosition, (Object)targetStructure);
                    distance = newDistance;
                }
            }
        }
        return Optional.ofNullable(nearest);
    }

    public static int adjustForTerrain(Structure.GenerationContext context, int xMin, int zMin, int xMax, int zMax, int gridLength) {
        int subDivisions = gridLength - 1;
        IntArrayList heights = new IntArrayList(gridLength * gridLength);
        for (int zStep = 0; zStep <= subDivisions; ++zStep) {
            int zPos = Mth.lerpDiscrete((float)((float)zStep / (float)subDivisions), (int)zMin, (int)zMax);
            for (int xStep = 0; xStep <= subDivisions; ++xStep) {
                int xPos = Mth.lerpDiscrete((float)((float)xStep / (float)subDivisions), (int)xMin, (int)xMax);
                heights.add(context.chunkGenerator().getFirstOccupiedHeight(xPos, zPos, Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState()));
            }
        }
        heights.sort((a, b) -> Integer.compare(b, a));
        double weightedSum = 0.0;
        double totalWeight = 0.0;
        for (int i = 0; i < heights.size(); ++i) {
            double weight = i + 1;
            weightedSum += weight * (double)heights.getInt(i);
            totalWeight += weight;
        }
        return (int)Math.round(weightedSum / totalWeight);
    }

    public static int adjustForTerrain(Structure.GenerationContext context, int xInCenterChunk, int zInCenterChunk, int radiusFromCenterChunk, int gridLength) {
        int chunkOriginX = xInCenterChunk & 0xFFFFFFF0;
        int chunkOriginZ = zInCenterChunk & 0xFFFFFFF0;
        return WorldUtil.adjustForTerrain(context, chunkOriginX - radiusFromCenterChunk, chunkOriginZ - radiusFromCenterChunk, chunkOriginX + 15 + radiusFromCenterChunk, chunkOriginZ + 15 + radiusFromCenterChunk, gridLength);
    }
}

