/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import twilightforest.enchantment.RechargeScepterEffect;
import twilightforest.entity.projectile.TwilightWandBolt;
import twilightforest.init.TFEnchantments;
import twilightforest.init.TFItems;
import twilightforest.init.TFSounds;
import twilightforest.util.TFItemStackUtils;

public class TwilightWandItem
extends Item {
    public TwilightWandItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getDamageValue() == stack.getMaxDamage() && !player.getAbilities().instabuild) {
            return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
        }
        player.playSound((SoundEvent)TFSounds.TWILIGHT_SCEPTER_USE.get(), 1.0f, (level.getRandom().nextFloat() - level.getRandom().nextFloat()) * 0.2f + 1.0f);
        if (!level.isClientSide()) {
            level.addFreshEntity((Entity)new TwilightWandBolt(level, (LivingEntity)player));
            if (!(player.getAbilities().instabuild || player.getItemBySlot(EquipmentSlot.HEAD).is(TFItems.MYSTIC_CROWN) && !(level.getRandom().nextFloat() > 0.05f))) {
                TFItemStackUtils.hurtButDontBreak(stack, 1, (ServerLevel)level, (LivingEntity)player);
            }
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (entity.tickCount % 20 == 0 && level instanceof ServerLevel) {
            int renewal;
            ServerLevel serverLevel = (ServerLevel)level;
            if (stack.has(DataComponents.ENCHANTMENTS) && !isSelected && (renewal = ((ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS)).getLevel(level.holderOrThrow(TFEnchantments.RENEWAL))) > 0) {
                RechargeScepterEffect.applyRecharge(serverLevel, stack, entity);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)"item.twilightforest.scepter.desc", (Object[])new Object[]{stack.getMaxDamage() - stack.getDamageValue()}).withStyle(ChatFormatting.GRAY));
    }
}

